<?php

namespace App\Helpers;

class FilterHelper
{
    public static function amount($amount)
    {
        return preg_replace('/[^0-9+.]/', '', $amount);
    }

    public static function removeAllSpace($text)
    {
        return preg_replace('/\s+/', '', trim($text));
    }

    public static function makeMoneyWhole($amount)
    {
        $whole = round($amount, 0);
        $last = substr($whole, -1);
        $rest = substr($whole, 0, -1);

        $last = (int) $last;
        $rest = (int) $rest;

        if ($last != 0 && $last != 5) {

            if ($last < 5) {
                $last = 5;
            }

            if ($last > 5) {
                $last = 0;
                $rest = (int) $rest + 1;
            }
        }

        $famount = "$rest" . '' . "$last";
        return (int) $famount;
    }

    public static function calcDistance($lat1, $lon1, $lat2, $lon2)
    {
        $r = 6371; // km
        $p = pi() / 180;

        $a = 0.5 - cos(($lat2 - $lat1) * $p) / 2
         + cos($lat1 * $p) * cos($lat2 * $p) *
            (1 - cos(($lon2 - $lon1) * $p)) / 2;

        return 2 * $r * asin(sqrt($a));
    }

    public static function formatPrice($amount)
    {
        $currency = env('CURRENCY');
        return [
            "original" => $amount,
            "currency" => $currency,
            "withCurrency" => $amount . " " . $currency,
        ];
    }

    public static function dateObj($date)
    {
        if (!strtotime($date)) {
            return $obj = [
                'raw' => null,
                'sqlDate' => null,
                'sqlDateTime' => null,
                'withDay' => null,
                'withDayTime' => null,
            ];
        }

        $obj = [
            'raw' => $date,
            'sqlDate' => date('Y-m-d', strtotime($date)),
            'sqlDateTime' => date('Y-m-d H:i:s', strtotime($date)),
            'withDay' => date('D M d, Y', strtotime($date)),
            'withDayN' => date('D M d', strtotime($date)),
            'withDayTime' => date('D M d, Y h:i A', strtotime($date)),
            'withDayTime24' => date('D M d, Y H:i', strtotime($date)),
            'time' => date("h:i A", strtotime($date)),
            'time24' => date('H:i', strtotime($date)),
        ];
        return (object) $obj;
    }

    public static function fixPhoneNumber($mobile)
    {
        $mobile = strval($mobile);

        if (strlen($mobile) == 11) {
            $s = substr($mobile, 1);
            return "+234" . $s;
        }

        if (strlen($mobile) == 10) {
            return "+234" . $mobile;
        }

        return "";
    }

    public static function arrToObject($arr)
    {

        $ff = json_encode($arr);
        $ff = json_decode($ff);

        return $ff;
    }

    public static function amountToNaira($amount)
    {
        return round($amount / 100, 2);
    }

    public static function formatTradeAction($action)
    {
        $type = env('TRADE_ACTION_TYPE') ?? 'up';

        if($type == 'buy'){
            if($action == strtolower('up')){
                return 'buy';
            }
            else{
                return 'sell';
            }
        }

        if($type == 'put'){
            if($action == strtolower('up')){
                return 'put';
            }
            else{
                return 'call';
            }
        }

        if($type == 'up'){
            if($action == strtolower('up')){
                return 'up';
            }
            else{
                return 'down';
            }
        }

        if($action == strtolower('up')){
            return 'buy';
        }
        else{
            return 'sell';
        }
        
    }

    public static function convertLinksAndEmails($text) {
        // Convert URLs starting with http/https
        $pattern_url = '/(https?:\/\/[^\s]+)/i';
        $replacement_url = '<a href="$1" target="_blank" rel="noopener noreferrer">$1</a>';
        $text = preg_replace($pattern_url, $replacement_url, $text);
    
        // Convert URLs starting with www (but missing http/https)
        $pattern_www = '/\bwww\.[^\s]+/i';
        $replacement_www = '<a href="http://$0" target="_blank" rel="noopener noreferrer">$0</a>';
        $text = preg_replace($pattern_www, $replacement_www, $text);
    
        // Convert email addresses into mailto: links
        $pattern_email = '/[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}/i';
        $replacement_email = '<a href="mailto:$0">$0</a>';
        $text = preg_replace($pattern_email, $replacement_email, $text);
    
        return $text;
    }

    public static function getCurrencyArray() {
        $c = env("CURRENCIES");
        if($c){
            return array_map('trim', explode(',', $c));
        }

        return [];
    }

    public static function count_decimals($x)
    {
        return strlen(substr(strchr($x, "."), 1));
    }

    public static function randomMinMax($min, $max){
        $decimals = max(SELF::count_decimals($min), SELF::count_decimals($max));
        $factor = pow(10, $decimals);
        return rand($min * $factor, $max * $factor) / $factor;
    }
}
