<?php

namespace App\Http\Controllers\Api\Current;

use App\Events\CampaignDoneEvent;
use App\Events\RiderLocationUpdatedEvent;
use App\Events\TicketUpdatedEvent;
use App\Events\UserLocationUpdatedEvent;
use App\Helpers\FilterHelper;
use App\Http\Controllers\Controller;
use App\Services\WalletService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Str;

use App\Http\Resources\UserResource;
use App\Models\Campaign;
use App\Models\DistrictArea;
use App\Models\Staff;
use App\Models\Ticket;
use App\Models\User;
use App\Notifications\StaffNotification;
use App\Services\CustomService;
use App\Services\ExpoService;
use App\Services\PaystackService;

use Twilio;


class TesterController extends Controller
{
    public function __construct() {}

    public function runner(Request $request)
    {
        //    $user = User::find(1);

        //    $u = new UserResource($user);

        //     return response()->json($u);


        $path = public_path('top.jpg');

        // $uploadedFileUrl = cloudinary()->uploadVideo($path)->getSecurePath();
        // $uploadedFileUrl = cloudinary()->uploadApi()->upload($path);
        $uploadedFileUrl = cloudinary()->upload($path);
        // $res = $path->storeOnCloudinary();
        // $avatar = cloudinary()->getUrl('xhoookec1l7rdefnvurs');
        dd($uploadedFileUrl->getResponse()['version']);
        // dd($res);
        // dd($avatar);

    }

    public function cloudinary(Request $request)
    {
        $result = $request->image->storeOnCloudinary();
        dd($result->cloudinary());
        // dd($result);
    }

    public function tester_pa(Request $request)
    {
        $polygon = DistrictArea::where("district_id", 1)->orderBy("rank", "ASC")->get()->map(function ($ri) {
            return [
                "lat" => (double)$ri->lat,
                "lng" => (double)$ri->lng,
            ];
        });

        $p = $polygon->toArray();
        // dd($p);
        // shride
        echo CustomService::isPointInPolygon($polygon,  [7.369060, 3.828218]);
        echo "<br/>";
        echo CustomService::isPointInPolygon($polygon,  [7.442520, 3.908304]);
        echo "<br/>";

        // OLD BODIJA
        echo CustomService::isPointInPolygon($polygon,  [7.422506, 3.896308]);
    }
}
