<?php

namespace App\Http\Controllers\Api\Current;

use App\Helpers\ResponseHelper;
use App\Helpers\SettingsHelper;
use App\Http\Controllers\Controller;
use App\Models\Plan;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Str;

use App\Models\User;
use App\Services\NowpaymentService;
use App\Services\WalletService;
use Carbon\Carbon;
use DateTime;

class UtilsController extends Controller
{
    public function __construct() {}

    public function plans(Request $request)
    {
        $r = Plan::orderBy('id', 'desc')->get();

        return ResponseHelper::json([
            'status' => true,
            'data' => $r,
        ]);
    }

    public function get_deposit_gateway(Request $request)
    {
        $gate = SettingsHelper::getValue(null, "current_crypto_gateway");

        return ResponseHelper::json([
            'status' => true,
            'data' => $gate,
        ]);
    }

    public function get_deposit_coins(Request $request)
    {
        $coins = (new NowpaymentService())->get_coins();

        if ($coins) {

            return ResponseHelper::json([
                'status' => true,
                'data' => $coins,
            ]);
        } else {
            return ResponseHelper::json([
                'status' => false,
                'data' => [],
            ]);
        }
    }
}
