<?php

namespace App\Http\Controllers\Web\Current\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Inertia\Inertia;

use App\Models\Staff;
use App\Models\Admin;


class AuthController extends Controller
{
    public function __construct() {}

    public function login(Request $request)
    {
        if ($request->has('login')) {
            $validator = Validator::make($request->all(), [
                'email' => 'required',
                'password' => 'required',
            ]);

            if ($validator->fails()) {
                return redirect()
                    ->back()
                    ->with('error', $validator->messages()->first())->withInput();
            } else {

                $admin = Admin::where('email', strtolower($request->email))->first();

                if ($admin) {
                    if ($request->password == $admin->password) {
                        Auth::guard('admin')->login($admin);
                        $admin->last_login_date = now();
                        $admin->ip_address = $request->ip();
                        $admin->metadata = $request->server('HTTP_USER_AGENT');
                        $admin->save();

                        return redirect()
                            ->intended(route('admin.dashboard'))
                            ->with(
                                'success',
                                "Welcome Back"
                            );

                        // if ($admin->last_login_date) {
                        //     return redirect()
                        //         ->intended(route('admin.staff'))
                        //         ->with(
                        //             'popsuccess',
                        //             "Welcome Back"
                        //         );
                        // } else {
                        //     return redirect()
                        //         ->route('admin.profile')
                        //         ->with(
                        //             'popsuccess',
                        //             "Firstly, Change Your Password"
                        //         );
                        // }
                    } else {
                        return redirect()
                            ->back()
                            ->with('error', 'Wrong Password')->withInput();
                    }
                } else {
                    return redirect()
                        ->back()
                        ->with('error', 'Invalid Login Details')->withInput();
                }
            }
        }

        // Auth::guard('staff')->logout();

        return view('auth/admin_login');
    }
}
