<?php

namespace App\Http\Controllers\Web\Current\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Inertia\Inertia;

use App\Models\User;
use App\Models\DocumentConfig;

class NotificationController extends Controller
{
    public function __construct()
    {
    }

    public function index(Request $request)
    {

        $users = User::orderBy("id", "desc")->get();

        return Inertia::render("Admin/Settings/Index", [
            'page_title' => "Users",
        ]);
    }

    public function verification_config(Request $request)
    {
        if ($request->has('create_requirement')) {
            $validator = Validator::make($request->all(), [
                'type' => 'required',
                'name' => 'required',
            ]);

            if ($validator->fails()) {
                return
                    back()
                    ->with('poperror', $validator->messages()->first());
            } else {
                $checker = DocumentConfig::where("type", strtolower($request->type))->where("name", strtolower($request->name))->first();

                if ($checker) {
                    return redirect()
                        ->back()
                        ->with('poperror', "$request->name already added");
                }

                $r = new DocumentConfig();
                $r->type =  strtolower($request->type);
                $r->name =  strtolower($request->name);
                $r->field_title =  strtolower($request->field_label);
                $r->has_upload = $request->has_upload == true ? 1 : 0;
                $r->has_two_sides_image = $request->has_two_sides_image == true ? 1 : 0;
                $r->has_field = $request->has_field == true ? 1 : 0;
                $r->is_active = $request->activated == true ? 1 : 0;

                $r->save();

                return redirect()
                    ->back()
                    ->with('popsuccess', "Record Created");
            }
        }

        if ($request->has('edit_requirement')) {
            $validator = Validator::make($request->all(), [
                'type' => 'required',
                'name' => 'required',
                'record_id' => 'required',
            ]);

            if ($validator->fails()) {
                return
                    back()
                    ->with('poperror', $validator->messages()->first());
            } else {
                $doc = DocumentConfig::find($request->record_id);

                if ($doc) {
                    $checker = DocumentConfig::where("type", strtolower($request->type))
                        ->where("name", strtolower($request->name))
                        ->where("id", "!=", $request->record_id)->first();

                    if ($checker) {
                        return redirect()
                            ->back()
                            ->with('poperror', "$request->name already added");
                    }

                    $doc->type =  strtolower($request->type);
                    $doc->name =  strtolower($request->name);
                    $doc->field_title =  strtolower($request->field_label);
                    $doc->has_upload = $request->has_upload == true ? 1 : 0;
                    $doc->has_two_sides_image = $request->has_two_sides_image == true ? 1 : 0;
                    $doc->has_field = $request->has_field == true ? 1 : 0;
                    $doc->is_active = $request->activated == true ? 1 : 0;

                    $doc->save();

                    return redirect()
                        ->back()
                        ->with('popsuccess', "Record Updated");
                }
            }
        }

        $config = DocumentConfig::orderBy("id", "desc")->get();

        return Inertia::render("Admin/Settings/BikeDocument", [
            'page_title' => "Vehicle Requirement Settings",
            'documents' => $config,
            'document_types' => ['bike']
        ]);
    }

    public function general_settings($id, Request $request)
    {
        $user = User::find($id);

        // dd($user->firstname);
        if ($user) {
            return Inertia::render("Admin/User/View", [
                'page_title' => "$user->firstname Profile",
                'user' => $user
            ]);
        } else {
            return redirect()->route("admin.user");
        }
    }
}
