<?php

namespace App\Http\Controllers\Web\Current\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Hash;
use Inertia\Inertia;

use App\Enums\StaffRole;

use App\Models\Staff;

use App\Mail\WordMail;
use App\Models\Rider;
use App\Models\RiderPayout;
use App\Models\Trip;
use App\Models\User;
use App\Models\UserWalletTransaction;
use Illuminate\Support\Facades\DB;

class StaffController extends Controller
{
    public function __construct() {}

    public function index(Request $request)
    {
        $m = "<p>
                Hi OLUWASEGUN,
                <br/>
                <br/>
                Congratulations on your 1st Trip.
                <br/>
                <br/>
                It's been a pleasure to serve you, and you can easily re-apply for more money and better rates on your next loan, or enjoy great, secure savings with us!
                <br/>
                <br/>
                Click the button below to enjoy everything money today.
                <br/>
                <br/>
                <a href='' class='em-btn'>Withdraw Earnings</a>

                <a href='' class='em-btn'>Read More</a>
               </p>
                ";

        //        \Mail::to("dff@d.com")->send(new WordMail("Earnings", $m));
        //       return view("emails.word", ["data" => $m]);
        //       exit();

        if ($request->has('delete_staff')) {
            if ($request->staff_id == 1) {
                return redirect()
                    ->back()
                    ->with('poperror', "You cannot delete top admin");
            }

            $staff = Staff::find($request->staff_id);
            if ($staff) {
                $staff->delete();

                return redirect()
                    ->back()
                    ->with('popsuccess', "Staff Deleted");
            }
        }

        if ($request->reset_password == true) {
            $validator = Validator::make($request->all(), [
                'staff_id' => 'required',
            ]);

            if ($validator->fails()) {
                return
                    back()
                    ->with('poperror', $validator->messages()->first());
            } else {
                $staff = Staff::find($request->staff_id);
                if ($staff) {
                    $staff->password = Hash::make(1234);
                    $staff->last_login_date = NULL;
                    $staff->save();

                    return redirect()
                        ->back()
                        ->with('popsuccess', "Reset Done");
                } else {
                    return redirect()
                        ->back()
                        ->with('poperror', "Staff Not Found");
                }
            }
        }

        $staffs = Staff::orderBy("id", "desc")->get();
        return Inertia::render("Admin/Staff/Index", [
            'page_title' => "Staffs",
            'staffs' => $staffs
        ]);
    }

    public function create(Request $request)
    {
        if ($request->has('create_staff')) {
            $validator = Validator::make($request->all(), [
                'firstname' => 'required',
                'lastname' => 'required',
                'email' => 'required',
                'mobile' => 'required',
                'role' => 'required',
            ]);

            if ($validator->fails()) {
                return
                    back()
                    ->with('poperror', $validator->messages()->first());
            } else {
                $checker = Staff::where("email", strtolower($request->email))->first();
                if ($checker) {
                    return redirect()
                        ->back()
                        ->with('poperror', "Email already used");
                }

                $staff = new Staff();
                $staff->uuid = strtoupper("STF" . mt_rand(1111, 9999));
                $staff->firstname =  strtolower($request->firstname);
                $staff->lastname =  strtolower($request->lastname);
                $staff->email =  strtolower($request->email);
                $staff->role =  strtolower($request->role);
                $staff->mobile = $request->mobile;
                $staff->password = Hash::make(1111);
                $staff->save();

                $name = strtoupper($staff->firstname);
                $url = route("admin.login");
                $m = "<p>
                        Hi, $name
                        <br/>
                        <br/>
                        Welcome to Shride Portal.
                      
                        <br/>
                        Below are your login details
                        <br/>
                        <br/>
                        <a href='$url'>$url</a>
                        <br/>
                        Email: $staff->email
                        <br/>
                        Password: 1111
                        <br/>
                        <br/>
                        Set your new password at your first login.
                       </p>
                    ";

                Mail::to($staff->email)->queue(new WordMail("Welcome to Shride Portal", $m));

                return redirect()
                    ->route("admin.staff")
                    ->with('popsuccess', "Staff Created");
            }
        }

        return Inertia::render("Admin/Staff/Create", [
            'page_title' => "Create Staff",
            'roles' => StaffRole::toArray()
        ]);
    }

    public function update(Request $request)
    {
        return Inertia::render("Admin/Staff/Update", [
            'page_title' => "Update"
        ]);
    }

    public function profile(Request $request)
    {
        $staff = Staff::find(auth("staff")->user()->id);

        if ($request->has('update_password')) {
            $validator = Validator::make($request->all(), [
                'password' => 'required',
            ]);

            if ($validator->fails()) {
                return
                    back()
                    ->with('poperror', $validator->messages()->first());
            } else {

                $staff->password = Hash::make($request->password);
                $staff->last_login_date = now();
                $staff->save();
                auth("staff")->logout();

                $m = "<p>
                        Hi, $staff->fullname
                        <br/>
                        <br/>
                        Your password has been changed, Contact the admin if you didn't change the password. 
                    </p>
                    ";

                Mail::to($staff->email)->queue(new WordMail("Password Changed", $m));

                return redirect()
                    ->route("admin.login")
                    ->with('popsuccess', "Password Updated, you can now login");
            }
        }

        if ($request->set_fcm_token == true) {
            if ($request->token) {
                $staff->fcm_token = $request->token;
                $staff->save();

                return back();
            }
        }

        if ($request->mark_all_read == true) {
            $staff->unreadNotifications->markAsRead();
            return back();
        }

        if ($request->mark_read == true) {
            $n = $staff->notifications()->where("id", $request->id)->first();
            // dd($request->id);
            if ($n) {
                $n->markAsRead();
            }
            return back();
        }

        $s = array_diff_key($staff->toArray(), ['password' => '']);

        return Inertia::render("Admin/Profile", [
            'page_title' => "Your Profile",
            'staff' => $s,
        ]);
    }

    public function dashboard(Request $request)
    {
        // $rr = Rider::find(1);
        // dd($rr->ratings);

        $staff = auth("staff")->user();
        $from = isset($request->from) ? date("Y-m-d H:i:s", strtotime($request->from)) : today()->startOfMonth();
        $to =  isset($request->to) ? date("Y-m-d H:i:s", strtotime($request->to)) : today()->endOfMonth();

        $users = User::whereDate('created_at', ">=", $from)->whereDate('created_at', "<=", $to);
        $usersf = User::whereDate('created_at', ">=", $from)->whereDate('created_at', "<=", $to);

        $riders = Rider::whereDate('created_at', ">=", $from)->whereDate('created_at', "<=", $to);
        $ridersf = Rider::whereDate('created_at', ">=", $from)->whereDate('created_at', "<=", $to);

        $trips = Trip::whereDate('created_at', ">=", $from)->whereDate('created_at', "<=", $to);
        $tripsf = Trip::whereDate('created_at', ">=", $from)->whereDate('created_at', "<=", $to);

        // dd($users->get()->count());

        $deposits = UserWalletTransaction::where("type", "credit")->whereDate('created_at', ">=", $from)->whereDate('created_at', "<=", $to);
        $depositsf = UserWalletTransaction::where("type", "credit")->whereDate('created_at', ">=", $from)->whereDate('created_at', "<=", $to);

        $income = Trip::where("is_paid", 1)->whereDate('created_at', ">=", $from)->whereDate('created_at', "<=", $to);
        $incomef = Trip::where("is_paid", 1)->whereDate('created_at', ">=", $from)->whereDate('created_at', "<=", $to);

        $payouts = RiderPayout::where("is_done", 1)->whereDate('created_at', ">=", $from)->whereDate('created_at', "<=", $to);
        $payoutsf = RiderPayout::where("is_done", 1)->whereDate('created_at', ">=", $from)->whereDate('created_at', "<=", $to);

        $trips_arr = $incomef->selectRaw('count(id) as total, DATE(created_at) as date')
            ->groupBy('date')
            ->get()
            ->map(function ($item) {
                return [
                    'date'  => date('d M', strtotime($item->date)),
                    'total' => $item->total,
                ];
            });


        $riders_arr = $ridersf->selectRaw('count(id) as total, DATE(created_at) as date')
            ->groupBy('date')
            ->get()
            ->map(function ($item) {
                return [
                    'date'  => date('d M', strtotime($item->date)),
                    'total' => $item->total,
                ];
            });



        $users_arr = $usersf->selectRaw('COUNT(*) as total, DATE(created_at) as date')
            ->groupBy('date')
            ->get()
            ->map(function ($item) {
                return [
                    'date'  => date('d M', strtotime($item->date)),
                    'total' => $item->total,
                ];
            });

        $deposits_arr = $depositsf->selectRaw('sum(amount) as amount, DATE(created_at) as date')
            ->groupBy('date')
            ->get()
            ->map(function ($item) {
                return [
                    'date'  => date('d M', strtotime($item->date)),
                    'total' => $item->amount,
                ];
            });

        $income_arr = $incomef->selectRaw('sum(fee) as amount, DATE(created_at) as date')
            ->groupBy('date')
            ->get()
            ->map(function ($item) {
                return [
                    'date'  => date('d M', strtotime($item->date)),
                    'total' => $item->amount,
                ];
            });

        $payouts_arr = $payoutsf->selectRaw('sum(amount) as amount, DATE(created_at) as date')
            ->groupBy('date')
            ->get()
            ->map(function ($item) {
                return [
                    'date'  => date('d M', strtotime($item->date)),
                    'total' => $item->amount,
                ];
            });

        $s = array_diff_key($staff->toArray(), ['password' => '']);

        if ($staff->role->value == "superadmin") {
            return Inertia::render("Admin/Dashboard/Ceo", [
                'page_title' => "CEO Dashboard",
                'staff' => $s,
                'from' => $from,
                'to' => $to,
                'calc' => [
                    "users" => $users->get()->count(),
                    "riders" => $riders->get()->count(),
                    "trips" => $income->get()->count(),
                    "deposits" => $deposits->get()->sum("amount"),
                    "income" => $income->get()->sum("fee"),
                    "payouts" => $payouts->get()->sum("amount"),
                ],
                'graph' => [
                    "trips" => $trips_arr,
                    "riders" => $riders_arr,
                    "users" => $users_arr,
                    "deposits" => $deposits_arr,
                    "income" => $income_arr,
                    "payouts" => $payouts_arr,
                ]
            ]);
        } elseif ($staff->role->value  == "manager") {
            return Inertia::render("Admin/Dashboard/Manager", [
                'page_title' => "Manager Dashboard",
                'staff' => $s,
            ]);
        } else {
            return Inertia::render("Admin/Dashboard/Support", [
                'page_title' => "Dashboard",
                'staff' => $s,
                'from' => $from,
                'to' => $to,
            ]);
        }
    }
}
