<?php

namespace App\Http\Controllers\Web\Current\Admin;

use App\Helpers\FilterHelper;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

use App\Models\User;
use App\Models\Asset;
use App\Models\Market;
use App\Models\TopTrader;
use App\Models\TopTraderDemo;
use App\Models\Trade;
use App\Models\TradeBot;

class TradeController extends Controller
{

    public function __construct() {}

    public function index(Request $request)
    {
        if ($request->has('delete_trade')) {
            $validator = Validator::make($request->all(), [
                "c_id" => "required",
            ]);

            if ($validator->fails()) {
                return redirect()
                    ->back()
                    ->with($validator->messages()->first());
            } else {

                $record = Trade::find($request->c_id);
                if ($record) {
                    $record->delete();

                    return redirect()
                        ->back()
                        ->with('Done');
                }
            }
        }


        $trades = Trade::orderBy("id", "desc")->get();

        return view("admin.trades", [
            "page_title" => 'All Trades',
            "trades" => $trades,
        ]);
    }

    public function tradebots(Request $request)
    {
        if ($request->has('delete_bot')) {
            $validator = Validator::make($request->all(), [
                "bot_id" => "required",
            ]);

            if ($validator->fails()) {
                return redirect()
                    ->back()
                    ->with($validator->messages()->first());
            } else {

                $record = TradeBot::find($request->bot_id);
                if ($record) {
                    $record->delete();
                }

                return redirect()
                        ->back()
                        ->with('Done');
            }
        }

        if ($request->has('create_bot')) {
            $validator = Validator::make($request->all(), [
                "name" => "required",
                "details" => "required",
            ]);

            if ($validator->fails()) {
                return back()
                    ->with("error", $validator->messages()->first());
            } else {
                $image = null;

                if ($request->hasFile('avatar')) {
                    $image =  $request->avatar->store('/bots');
                }

                $td = new TradeBot();
                $td->uuid = mt_rand(111_111, 999_999);
                $td->name = $request->name;
                $td->details = $request->details;
                $td->picture = $image;
                $td->save();

                return redirect()
                    ->back()
                    ->with('Done');
            }
        }

        if ($request->has('edit_bot')) {
            $validator = Validator::make($request->all(), [
                "bot_id" => "required",
                "name" => "required",
                "details" => "required",
            ]);

            if ($validator->fails()) {
                return back()
                    ->with("error", $validator->messages()->first());
            } else {

                $ast = TradeBot::find($request->bot_id);
                if ($ast) {
                    $image = $request->picture;

                    if ($request->hasFile('avatar')) {
                        $image =  $request->avatar->store('/bots');
                    }

                    $ast->name = $request->name;
                    $ast->details = $request->details;
                    $ast->picture = $image;
                    $ast->save();
                }

                return redirect()
                    ->back()
                    ->with('success', 'Done');
            }
        }

        $bots = TradeBot::orderBy("id", "desc")->get();
        

        return view("admin.tradebots", [
            "page_title" => 'All Trade Bots',
            "bots" => $bots,
        ]);
    }

    public function toptraders(Request $request)
    {

        if (isset($_POST['delete'])) {
            $this->validate($request, [
                'trader_id' => 'required',
            ]);

            $record = TopTrader::find($request->trader_id);

            if ($record) {
                $record->delete();
                return back()->with("success", "Record Deleted");
            } else {
                return back()->with("error", "Record not Found");
            }
        }

        if (isset($_POST['create_trader'])) {
            $this->validate($request, [
                'username' => 'required',
                'firstname' => 'required',
                'lastname' => 'required',
                'success_rate' => 'required',
                'commision' => 'required',
                'largest_win' => 'required',
                'min_investment' => 'required',
            ]);

            $social_links = [
                "facebook" => $request->facebook,
                "twitter" => $request->twitter,
                "instagram" => $request->instagram,
                "telegram" => $request->telegram,
                "whatsapp" => $request->whatsapp,
            ];

            $trader = new TopTrader();

            $trader->username = strtolower($request->username);
            $trader->firstname = strtolower($request->firstname);
            $trader->lastname = strtolower($request->lastname);
            $trader->success_rate = $request->success_rate;
            $trader->about = $request->about;
            $trader->commision = FilterHelper::amount($request->commision);
            $trader->largest_win = $request->largest_win;
            $trader->min_investment = FilterHelper::amount($request->min_investment);
            $trader->copiers = $request->copiers;
            $trader->all_time_roi = $request->all_time_roi;
            $trader->social_links = $social_links;
            $trader->is_active = 1;
            if ($request->file('avatar')) {
                $picture = $request->file('avatar');

                $ext = strtolower($picture->getClientOriginalExtension());
                if (($ext != 'png') and ($ext != 'jpg') and ($ext != 'jpeg')) {
                    return back()->with("error", "Invalid file format Uploaded. Only jpg, jpeg, png supported.");
                }

                $trader->avatar = $picture->store("traders");
            }
            $trader->save();
            return back()->with("success", "Record Added");
        }


        $data['page_title'] = "Top Traders";
        $data['traders'] = TopTrader::orderBy('id', 'desc')->get();
        return view('admin/toptraders', $data);
    }

    public function view_toptrader($trader_id, Request $request)
    {

        $trader = TopTrader::find($trader_id);
        if ($trader) {
            if (isset($_POST['update_info'])) {
                $this->validate($request, []);

                $social_links = [
                    "facebook" => $request->facebook,
                    "twitter" => $request->twitter,
                    "instagram" => $request->instagram,
                    "telegram" => $request->telegram,
                    "whatsapp" => $request->whatsapp,
                ];

                $trader->username = strtolower($request->username);
                $trader->firstname = strtolower($request->firstname);
                $trader->lastname = strtolower($request->lastname);
                $trader->success_rate = $request->success_rate;
                $trader->about = $request->about;
                $trader->commision = FilterHelper::amount($request->commision);
                $trader->largest_win = $request->largest_win;
                $trader->min_investment = FilterHelper::amount($request->min_investment);
                $trader->copiers = $request->copiers;
                $trader->all_time_roi = $request->all_time_roi;
                $trader->social_links = $social_links;
                $trader->save();

                return back()->with("success", "Record Updated");
            }

            if (isset($_POST['update_picture'])) {
                $this->validate($request, []);

                if ($request->file('avatar')) {
                    $picture = $request->file('avatar');

                    $ext = strtolower($picture->getClientOriginalExtension());
                    if (($ext != 'png') and ($ext != 'jpg') and ($ext != 'jpeg')) {
                        return back()->with("error", "Invalid file format Uploaded. Only jpg, jpeg, png supported.");
                    }

                    $trader->avatar = $picture->store("traders");
                    $trader->save();
                }

                return back()->with("success", "Picture Updated");
            }

            if (isset($_POST['create_demo'])) {
                $this->validate($request, [
                    'year' => 'required',
                    'month' => 'required',
                    'total_wins' => 'required',
                    'total_loss' => 'required',
                ]);

                $record = new TopTraderDemo();
                $record->year = $request->year;
                $record->month = $request->month;
                $record->month = $request->month;
                $record->trader_id = $trader->id;
                $record->demo_date = "$request->year-$request->month-01";
                $record->win = FilterHelper::amount($request->total_wins);
                $record->loss = FilterHelper::amount($request->total_loss);

                $record->save();
                return back()->with("success", "Record Updated");
            }

            if (isset($_POST['delete_data'])) {
                $this->validate($request, [
                    'c_id' => 'required',
                ]);

                $record = TopTraderDemo::find($request->c_id);

                if ($record) {
                    $record->delete();
                    return back()->with("success", "Record Deleted");
                } else {
                    return back()->with("error", "Record not Found");
                }
            }
        } else {
            return redirect()->route("admin.toptrader");
        }

        $data['page_title'] = "Trader Profile - $trader->fullname";
        $data['trader'] = $trader;
        return view('admin/view_toptrader', $data);
    }

}
