<?php

namespace App\Http\Controllers\Web\Current;

use App\Helpers\SettingsHelper;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;

use App\Models\Deposit;
use App\Services\CryptomusService;
use App\Services\NowpaymentService;

class ScriptController extends Controller
{
    public function __construct() {}

    public function index(Request $request) {}

    public function verify_auto_pay($uuid, Request $request)
    {
        $deposit = Deposit::where("uuid", $uuid)->first();
        if ($deposit) {

            if ($deposit->gateway_type == "cryptomus") {
                $sr = new CryptomusService();
                $sr->verify_payment($deposit);
            }

            if ($deposit->gateway_type == "nowpayments") {
                $sr = new NowpaymentService();
                $tt = $sr->verify_payment($deposit);
                dd($tt);
            }

            $location = env("WEBAPP_URL") . "/deposit/payment/$deposit->uuid";
            header("Location: $location");
            exit();

        } else {

            $location = env("WEBAPP_URL") . "/deposit";
            header("Location: $location");
            exit();
        }
    }
}
