<?php

namespace App\Http\Middleware;

use Auth;
use Closure;
use Illuminate\Http\Request;

class Staff
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if (!Auth::guard('staff')->check()) {
            return redirect()
                ->route('admin.login')
                ->with('error', 'login needed');
        } else {
            $staff = Auth::guard('staff')->user();

            $not_allowed = [
                "admin.staff",
                "admin.setting",
                "admin.finance",
                "admin.finance.usertransaction",
                "admin.finance.ridertransaction",
            ];

            if ($staff->role->value != 'superadmin') {
                if (in_array($request->route()->action['as'], $not_allowed)) {
                    return redirect()
                        ->route('admin.user')
                        ->with(
                            'poperror',
                            "Not Allowed"
                        );
                }
            }

            if ($staff->last_login_date == NULL && $request->route()->action['as'] != "admin.profile") {
                return redirect()
                    ->route('admin.profile')
                    ->with(
                        'popsuccess',
                        "Firstly, Change Your Password"
                    );
            }

            if ($staff->last_login_date == NULL) {
                return redirect()
                    ->route('admin.login');
            }

            if ($staff->is_blocked == 1) {
                return redirect()
                    ->route('admin.login')
                    ->with(
                        'poperror',
                        "Access Denied, Contact Admin"
                    );
            }

            return $next($request);
        }
    }
}
