<?php

namespace App\Http\Resources;

use App\Helpers\FilterHelper;
use Illuminate\Http\Resources\Json\JsonResource;

class TradeResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return array_merge(parent::toArray($request), [
            'fmt_trade_action' => $this->fmt_trade_action,
            'created_at' => FilterHelper::dateObj($this->created_at),
            'ends_at' => FilterHelper::dateObj($this->ends_at),
        ]);
    }
}
