<?php

namespace App\Jobs;

use App\Models\Rider;
use App\Models\Vehicle;
use App\Models\VehicleDocument;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\File;

class UploadToCloudinaryJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     */
    public function __construct(public $type, public $record_id)
    {
        //
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        echo "got job \n";
        if ($this->type == "vehicle") {
            $vehicle = Vehicle::find($this->record_id);
            if ($vehicle) {
                try {
                    if ($vehicle->front_picture) {
                        $name = $vehicle->front_picture['public_id'];
                        $path = "/faulty/img/$name";
                        $img = public_path($path);

                        if (File::exists($img)) {
                            $uploaded = cloudinary()->upload(public_path($path));
                            $res = $uploaded->getResponse();
                            $fp = $vehicle->avatar;

                            if ($res) {
                                $fp = [
                                    'public_id' => $res['public_id'],
                                    'url' => $res['secure_url'],
                                    'version' => $res['version'],
                                    'format' => $res['format'],
                                ];

                                $vehicle->front_picture = $fp;
                                $vehicle->save();
                                unlink(public_path($path));
                            }
                        }
                    }

                    if ($vehicle->back_picture) {
                        $name2 = $vehicle->back_picture['public_id'];
                        $path2 = "/faulty/img/$name2";
                        $img2 = public_path($path2);

                        if (File::exists($img2)) {
                            $uploaded2 = cloudinary()->upload(public_path($path2));
                            $res2 = $uploaded2->getResponse();
                            $bp = $vehicle->back_picture;

                            if ($res2) {
                                $bp = [
                                    'public_id' => $res2['public_id'],
                                    'url' => $res2['secure_url'],
                                    'version' => $res2['version'],
                                    'format' => $res2['format'],
                                ];

                                $vehicle->back_picture = $bp;
                                $vehicle->save();
                                unlink(public_path($path2));
                            }
                            echo $vehicle->id . " " . $img2 . " -> " . $res2['public_id'] . " back<br/>";
                        }
                    }
                } catch (\Throwable $e) {
                    echo "\n\nerror: " . $e->getMessage();
                }
            }
        }

        if ($this->type == "vehicle_document") {
            echo "got to vehicle document";
            $vehicle = VehicleDocument::find($this->record_id);
            if ($vehicle) {
                try {
                    if ($vehicle->front_picture) {
                        $name = $vehicle->front_picture['public_id'];
                        $path = "/faulty/img/$name";
                        $img = public_path($path);

                        if (File::exists($img)) {
                            $uploaded = cloudinary()->upload(public_path($path));
                            $res = $uploaded->getResponse();
                            $fp = $vehicle->avatar;

                            if ($res) {
                                $fp = [
                                    'public_id' => $res['public_id'],
                                    'url' => $res['secure_url'],
                                    'version' => $res['version'],
                                    'format' => $res['format'],
                                ];

                                $vehicle->front_picture = $fp;
                                $vehicle->save();
                                unlink(public_path($path));
                            }

                            // dd($fp);
                            echo $vehicle->id . " " . $img . " -> " . $res['public_id'] . " front \n";
                        }
                    }

                    if ($vehicle->back_picture) {
                        $name2 = $vehicle->back_picture['public_id'];
                        $path2 = "/faulty/img/$name2";
                        $img2 = public_path($path2);

                        if (File::exists($img2)) {
                            $uploaded2 = cloudinary()->upload(public_path($path2));
                            $res2 = $uploaded2->getResponse();
                            $bp = $vehicle->back_picture;

                            if ($res2) {
                                $bp = [
                                    'public_id' => $res2['public_id'],
                                    'url' => $res2['secure_url'],
                                    'version' => $res2['version'],
                                    'format' => $res2['format'],
                                ];

                                $vehicle->back_picture = $bp;
                                $vehicle->save();
                                unlink(public_path($path2));
                            }
                            echo $vehicle->id . " " . $img2 . " -> " . $res2['public_id'] . " back \n";
                        }
                    }
                } catch (\Throwable $e) {
                    echo "error: " . $e->getMessage();
                }
            }
        }

        if ($this->type == "rider_avatar") {
            $rider = Rider::find($this->record_id);
            if ($rider) {
                try {
                    if ($rider->avatar) {
                        $name = $rider->avatar['public_id'];
                        $path = "/faulty/img/$name";
                        $img = public_path($path);

                        if (File::exists($img)) {
                            $uploaded = cloudinary()->upload(public_path($path));
                            $res = $uploaded->getResponse();
                            $fp = $rider->avatar;

                            if ($res) {
                                $fp = [
                                    'public_id' => $res['public_id'],
                                    'url' => $res['secure_url'],
                                    'version' => $res['version'],
                                    'format' => $res['format'],
                                ];

                                $rider->avatar = $fp;
                                $rider->save();
                                unlink(public_path($path));
                            }
                        }
                    }
                } catch (\Throwable $e) {
                    echo "\n\nerror: " . $e->getMessage();
                }
            }
        }
    }
}
