<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\File;

class Asset extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'assets';
    protected $guarded = [];
    protected $appends = [];

    public function getSymbolAttribute()
    {
        return $this->base_symbol . "" . $this->quote_symbol;
    }

    public function getSymbolSlashAttribute()
    {
        if ($this->quote_symbol) {
            return $this->base_symbol . "/" . $this->quote_symbol;
        }

        return $this->base_symbol;
    }

    public function getBaseImageUrlAttribute()
    {
        $path = public_path("static/assets/$this->base_symbol.png");
        if (File::exists($path)) {
            return asset("static/assets/$this->base_symbol.png");
        }

        if ($this->base_symbol) {
            return asset("static/assets/asset.png");
        }

        return null;
    }

    public function getQuoteImageUrlAttribute()
    {
        $path = public_path("static/assets/$this->quote_symbol.png");
        if (File::exists($path)) {
            return asset("static/assets/$this->quote_symbol.png");
        }

        if ($this->quote_symbol) {
            return asset("static/assets/asset.png");
        }

        return null;
    }
}
