<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Deposit extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'deposits';
    public $guarded = [];
    protected $appends = ["receipt_url"];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function trader()
    {
        return $this->belongsTo(TradingAccount::class);
    }

    public function getReceiptUrlAttribute()
    {
        if($this->receipt){
            return asset($this->receipt);
        }
        
        return null;
    }

}
