<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Helpers\FilterHelper;

class TicketInvite extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'ticket_invites';
    protected $guarded = [];
    protected $appends = [
     "created_at_obj", "message_html","staff_fullname"
    ];

    public function ticket()
    {
        return $this->belongsTo(
            Ticket::class,
        );
    }

    public function staff()
    {
        return $this->belongsTo(
            Staff::class,
        );
    }

    public function invited_by()
    {
        return $this->belongsTo(
            Staff::class, "id", "invited_by_id"
        );
    }

    public function getStaffFullnameAttribute()
    {
        return $this->staff->fullname ?? "";
    }

    public function getMessageHtmlAttribute()
    {
        return nl2br(htmlentities($this->message, ENT_QUOTES, 'UTF-8'));
    }

    protected function getCreatedAtObjAttribute()
    {
        return  FilterHelper::dateObj($this->created_at);
    }
}
