<?php

namespace App\Models;

use App\Helpers\FilterHelper;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TopTrader extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'top_traders';
    protected $guarded = [];
    protected $appends = ["about_html", "avatar_url", "fullname"];
    protected $casts = [
        "social_links" => "object"
    ];

    public function user()
    {
        return $this->belongsTo(User::class, $this->user_id);
    }

    public function demos()
    {
        return $this->hasMany(TopTraderDemo::class, 'trader_id', "id")->orderBy("demo_date", "DESC");
    }

    public function user_copy_traders()
    {
        return $this->hasMany(UserCopyTrader::class, 'trader_id', "id");
    }

    public function getFullNameAttribute()
    {
        return $this->firstname . " " . $this->lastname;
    }

    public function getAboutHtmlAttribute()
    {
        if ($this->about) {
            $m = nl2br(htmlentities($this->about, ENT_QUOTES, 'UTF-8'));
            return FilterHelper::convertLinksAndEmails($m);
        }
        return null;
    }

    public function getAvatarUrlAttribute()
    {
        if ($this->avatar) {
            return asset($this->avatar);
        } else {
            return asset('/static/bot.png');
        }
    }
}
