<?php

namespace App\Models;

use App\Helpers\FilterHelper;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Trade extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'trades';
    protected $guarded = [];
    protected $appends = [];

    public function user()
    {
        return $this->belongsTo(
            User::class,
        );
    }

    public function trader()
    {
        return $this->belongsTo(
            TradingAccount::class,
        );
    }

    public function getFmtTradeActionAttribute()
    {
        return FilterHelper::formatTradeAction($this->trade_action);
    }

    public function getProfitLossAttribute()
    {
        if ($this->is_trade_done == 1) {
            return round(($this->payout - $this->amount), 2);
        }

        return 0;
    }

    public function getTradePlacedByAttribute()
    {
        if ($this->is_auto_trade) {
            return 'auto';
        }

        if ($this->source_id) {
            return 'copy';
        }

        return 'manual';
    }
}
