<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TradingAccount extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'trading_accounts';
    protected $guarded = [];
    protected $appends = [];

    public function user()
    {
        return $this->belongsTo(
            User::class,
        );
    }

    public function trades()
    {
        return $this->hasMany(
            Trade::class,
            "trader_id"
        );
    }

    public function deposits()
    {
        return $this->hasMany(
            Deposit::class,
            "trader_id"
        );
    }

    public function withdrawals()
    {
        return $this->hasMany(
            Withdrawal::class,
            "trader_id"
        );
    }

    public function bots()
    {
        return $this->hasMany(
            UserTradeBot::class,
            "trader_id"
        );
    }
}
