<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;

use App\Helpers\FilterHelper;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Attributes\ObservedBy;

use App\Observers\UserObserver;


#[ObservedBy([UserObserver::class])]
class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, SoftDeletes;

    protected $table = 'users';
    protected $guarded = [];

    protected $appends = [];

    public function trading_accounts()
    {
        return $this->hasMany(
            TradingAccount::class,
        );
    }

    public function deposits()
    {
        return $this->hasMany(
            Deposit::class,
        );
    }

    public function active_trading_accounts()
    {
        return $this->trading_accounts()->where("is_active", 1);
    }

    public function plan()
    {
        return $this->belongsTo(
            Plan::class,
        );
    }

    public function trades()
    {
        return $this->hasMany(
            Trade::class
        );
    }

    public function bots()
    {
        return $this->hasMany(
            UserTradeBot::class
        );
    }

    public function toptraders()
    {
        return $this->hasMany(
            UserCopyTrader::class
        );
    }

    public function trade_predictions()
    {
        return $this->hasMany(
            TradePrediction::class
        );
    }

    public function deposit_payment_settings()
    {
        return $this->hasMany(
            PaymentSettings::class
        );
    }

    public function user_copy_traders()
    {
        return $this->hasMany(
            UserCopyTrader::class
        );
    }

    public function crypto()
    {
        return $this->hasMany(
            UserCrypto::class
        );
    }

    public function banks()
    {
        return $this->hasMany(
            UserBank::class
        );
    }

    public function ids()
    {
        return $this->hasMany(
            UserId::class
        );
    }

    public function getWalletBalanceAttribute()
    {
        return $this->trading_accounts->where("type", "live")->sum("balance");
    }

    public function getFullNameAttribute()
    {
        return $this->firstname . " " . $this->lastname;
    }

    public function getAvatarUrlAttribute()
    {
        if ($this->avatar) {
            return asset($this->avatar);
        } else {
            return asset('/static/avatar.jpg');
        }
    }



    // public function scopeOnline($query)
    // {
    //     $now = date("Y-m-d H:i:s", strtotime(now()->subMinute(2)));
    //     $query->whereHas('searching_trips', function ($query) use ($now) {
    //         $query->where("updated_at", ">=", $now);
    //     });
    // }

    // public function scopeOntrip($query)
    // {
    //     $query->whereHas('trips', function ($query) {
    //         $query->where("status", 'ontrip')
    //             ->where("is_done", 0);
    //     });
    // }
}
