<?php

namespace App\Models;

use App\Helpers\FilterHelper;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class UserCopyTrader extends Model
{
    use HasFactory;
    protected $table = 'user_copy_traders';
    protected $guarded = [];

    protected $appends = [];

    public function user()
    {
        return $this->belongsTo(
            User::class,
        );
    }

    public function trader()
    {
        return $this->belongsTo(
            TopTrader::class, "toptrader_id"
        );
    }

}
