<?php

namespace App\Models;

use App\Helpers\FilterHelper;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class UserTradeBot extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'user_tradebots';
    protected $guarded = [];

    protected $appends = [];

    public function user()
    {
        return $this->belongsTo(
            User::class,
        );
    }

    public function trader()
    {
        return $this->belongsTo(
            TradingAccount::class,
        );
    }

    public function bot()
    {
        return $this->belongsTo(
            TradeBot::class, "tradebot_id"
        );
    }

}
