<?php

namespace App\Notifications\Channels;

use App\Services\ExpoService;
use Illuminate\Notifications\Notification;

class ExpoNotificationChannel
{
    /**
     * Send the given notification.
     */
    public function send(object $notifiable, Notification $notification): void
    {
        // dd($notifiable);
        $data = method_exists($notification, 'toExpo')
            ? $notification->toExpo($notifiable)
            : null;
        if (empty($data)) {
            return;
        }

        if($notifiable->device_token){
            (new ExpoService())->send_notification($notifiable->device_token, $data['title'] ?? "", $data['message'] ?? "", ["abc" => 123]);
        }

        // (new ExpoService())->send_notification("ExponentPushToken[YDrY4vPM75B4KyN24PiA81]", $data['title'] ?? "", $data['message'] ?? "", ["frr" => 123]);
        // (new ExpoService())->send_notification("ExponentPushToken[IUXSmqGU_yLRoJ-KAZ6AYn]", $data['title'] ?? "", $data['message'] ?? "", ["abc" => 123]);

        return;

    }
}
