<?php

namespace App\Notifications;

use App\Notifications\Channels\ExpoNotificationChannel;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class UserNotification extends Notification implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    protected $gchannels;
    public function __construct(
        public $title = null,
        public $message,
        public $channel = null
    ) {
        $this->gchannels = [
            "expo" => ExpoNotificationChannel::class,
            "database" => "database",
        ];

        $this->afterCommit();
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable)
    {

        if ($this->channel) {
            $cc = [];

            foreach ($this->channel as $k => $r) {
                if ($this->gchannels[$r]) {
                    array_push($cc, $this->gchannels[$r]);
                }
            }

            return $cc;
        }

        return [ExpoNotificationChannel::class, "database"];
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            "title" => $this->title,
            "message" => $this->message
        ];
    }

    public function toExpo(object $notifiable): array
    {
        return [
            "title" => $this->title,
            "message" => $this->message
        ];
    }

    public function databaseType(object $notifiable): string
    {
        return 'user-notification';
    }
}
