<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Gate;
use Illuminate\Database\Eloquent\Model;


class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Model::preventLazyLoading(! app()->isProduction());
        // Model::preventLazyLoading();

        Gate::define('viewPulse', function ($user) {

            if (app()->isProduction()) {
                $allowed_addresses = explode(",", env('REMOTE_ADDRESSES'));
                return in_array(request()->ip(), $allowed_addresses);
            } else {
                return true;
            }
        });
    }
}
