<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;
use App\Helpers\FilterHelper;
use App\Helpers\SettingsHelper;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Log;


class ExpoService
{

    private $headers;
    private $base_url;

    public function __construct()
    {
        $this->headers = [
            'accept' => 'application/json',
            'content-type' => 'application/json',
        ];

        $this->base_url = "https://exp.host/--/api/v2/push/send";
    }

    // public function send_expo_notification($token, $title = '', $message = '', $data): bool
    // {
    //     try {
    //         $response = Http::withHeaders($this->headers)->post($this->base_url, [
    //             "to" => $token,
    //             "title" => $title,
    //             "body" => $message,
    //             "data" => $data,
    //             "priority" => "high",
    //             "channelId" => "default",
    //             "_contentAvailable" => true,
    //             "badge" => 0
    //         ]);


    //         $rr = json_decode($response->body());

    //         // dd($rr->data->status);
    //         if ($rr->data->status == "ok" || $rr->data->status == "OK" || $rr->data->status == "OK") {
    //             return true;
    //         }

    //         return false;
    //     } catch (\Throwable $e) {
    //         report($e);
    //         return false;
    //     }
    // }

    // public function send_notification($token, $title = '', $message = '', $data): bool
    // {
    //     $otoken = SettingsHelper::getObj(null,"oauth_token");

    //     try {
    //         $response = Http::withHeaders(
    //             [
    //                 'accept' => 'application/json',
    //                 'authorization' => 'Bearer ' . $otoken->value,
    //                 'content-type' => 'application/json',
    //             ]
    //         )->post("https://fcm.googleapis.com/v1/projects/shrideapp-b2e8a/messages:send", [
    //             "message" => [
    //                 "token" => $token,
    //                 "data" => [
    //                     "title" => $title,
    //                     "message" => $message,
    //                     "body" => json_encode($data),
    //                     "channelId" => "default",
    //                     "scopeKey" => "@devsegun/shriderider",
    //                     "experienceId" => "@devsegun/shriderider"
    //                 ],
    //             ]
    //         ]);


    //         File::append(public_path() . '/static/webhook.txt', "=============================\n\n normal " . $response->body() . PHP_EOL . "\n=============================");

    //         $rr = json_decode($response->body());
    //         if(isset($rr->name)){
    //             return true;
    //         }

    //         return false;
    //     } catch (\Throwable $e) {
    //         report($e);
    //         return false;
    //     }
    // }

    public function convert_apn_to_fcm_token($token)
    {
        $otoken = SettingsHelper::getObj(null, "oauth_token");

        try {
            $response = Http::withHeaders(
                [
                    'accept' => 'application/json',
                    'authorization' => 'Bearer ' . $otoken->value,
                    'content-type' => 'application/json',
                    'access_token_auth' => 'true'
                ]
            )->post("https://iid.googleapis.com/iid/v1:batchImport", [
                "application" => "com.shride.app",
                "sandbox" => false,
                "apns_tokens" => [
                    $token
                ]
            ]);


            File::append(public_path() . '/static/webhook.txt', "=============================\n\n a_to_f " . $response->body() . PHP_EOL . "\n=============================");

            $rr = json_decode($response->body());
            // dd(isset($rr->results));
            // dd($rr->results[0]->registration_token);
            if (isset($rr->results)) {
                return $rr->results[0]->registration_token;
            } else {
                return false;
            }
        } catch (\Throwable $e) {
            report($e);
            return false;
        }
    }

    public function send_notification($token, $title = '', $message = '', $data): bool
    {
        $otoken = SettingsHelper::getObj(null, "oauth_token");

        try {
            $response = Http::withHeaders(
                [
                    'accept' => 'application/json',
                    'authorization' => 'Bearer ' . $otoken->value,
                    'content-type' => 'application/json',
                ]
            )->post("https://fcm.googleapis.com/v1/projects/shrideapp-b2e8a/messages:send", [
                "message" => [
                    "token" => $token,
                    "notification" => [
                        "title" => $title,
                        "body" => $message,
                        // "image" => "https://shrideapp.com/logo-black.png"
                    ],
                    "data" => [
                        "channelId" => "default",
                        "scopeKey" => "@devsegun/shrideapp",
                        "experienceId" => "@devsegun/shrideapp"
                    ],
                ]
            ]);


            // File::append(public_path() . '/static/webhook.txt', "=============================\n\n normal " . $response->body() . PHP_EOL . "\n=============================");

            $rr = json_decode($response->body());
            // dd(isset($rr->name));
            if (isset($rr->name)) {
                return true;
            } else {
                return false;
            }
        } catch (\Throwable $e) {
            report($e);
            return false;
        }
    }

    public function send_user_campaign($title = '', $message = '', $data): bool
    {
        $otoken = SettingsHelper::getObj(null, "oauth_token");

        try {
            $response = Http::withHeaders(
                [
                    'accept' => 'application/json',
                    'authorization' => 'Bearer ' . $otoken->value,
                    'content-type' => 'application/json',
                ]
            )->post("https://fcm.googleapis.com/v1/projects/shrideapp-b2e8a/messages:send", [
                "message" => [
                    "topic" => 'user',
                    "notification" => [
                        "title" => $title,
                        "body" => $message,
                    ],
                    "data" => [
                        "channelId" => "default",
                        "scopeKey" => "@devsegun/shrideapp",
                        "experienceId" => "@devsegun/shrideapp"
                    ],
                ]
            ]);


            File::append(public_path() . '/static/webhook.txt', "=============================\n\n user campaign " . $response->body() . PHP_EOL . "\n=============================");

            $rr = json_decode($response->body());
            // dd(isset($rr->name));
            if (isset($rr->name)) {
                return true;
            } else {
                return false;
            }
        } catch (\Throwable $e) {
            report($e);
            return false;
        }
    }

    public function send_rider_notification($token, $title = '', $message = '', $data): bool
    {
        $otoken = SettingsHelper::getObj(null, "oauth_token");

        try {
            $response = Http::withHeaders(
                [
                    'accept' => 'application/json',
                    'authorization' => 'Bearer ' . $otoken->value,
                    'content-type' => 'application/json',
                ]
            )->post("https://fcm.googleapis.com/v1/projects/shrideapp-b2e8a/messages:send", [
                "message" => [
                    "token" => $token,
                    "notification" => [
                        "title" => $title,
                        "body" => $message,
                    ],
                    "data" => [
                        // "title" => $title,
                        // "message" => $message,
                        // "body" => json_encode($data),
                        "channelId" => "default",
                        "scopeKey" => "@devsegun/shriderider",
                        "experienceId" => "@devsegun/shriderider"
                    ],
                ]
            ]);


            File::append(public_path() . '/static/webhook.txt', "=============================\n\n rider noti " . $response->body() . PHP_EOL . "\n=============================");

            $rr = json_decode($response->body());
            // dd(isset($rr->name));
            if (isset($rr->name)) {
                return true;
            } else {
                return false;
            }
        } catch (\Throwable $e) {
            report($e);
            return false;
        }
    }

    public function send_rider_campaign($title = '', $message = '', $data): bool
    {
        $otoken = SettingsHelper::getObj(null, "oauth_token");

        try {
            $response = Http::withHeaders(
                [
                    'accept' => 'application/json',
                    'authorization' => 'Bearer ' . $otoken->value,
                    'content-type' => 'application/json',
                ]
            )->post("https://fcm.googleapis.com/v1/projects/shrideapp-b2e8a/messages:send", [
                "message" => [
                    "topic" => 'rider',
                    "notification" => [
                        "title" => $title,
                        "body" => $message,
                    ],
                    "data" => [
                        "channelId" => "default",
                        "scopeKey" => "@devsegun/shriderider",
                        "experienceId" => "@devsegun/shriderider"
                    ],
                ]
            ]);


            // File::append(public_path() . '/static/webhook.txt', "=============================\n\n normal " . $response->body() . PHP_EOL . "\n=============================");

            $rr = json_decode($response->body());
            // dd(isset($rr->name));
            if (isset($rr->name)) {
                return true;
            } else {
                return false;
            }
        } catch (\Throwable $e) {
            report($e);
            return false;
        }
    }

    public function send_rider_request_notification($token, $title = '', $message = '', $data): bool
    {
        $otoken = SettingsHelper::getObj(null, "oauth_token");

        try {
            $response = Http::withHeaders(
                [
                    'accept' => 'application/json',
                    'authorization' => 'Bearer ' . $otoken->value,
                    'content-type' => 'application/json',
                ]
            )->post("https://fcm.googleapis.com/v1/projects/shrideapp-b2e8a/messages:send", [
                "message" => [
                    "token" => $token,
                    "data" => [
                        // "title" => $title,
                        // "message" => $message,
                        // "body" => json_encode($data),
                        "channelId" => "rider_request",
                        "scopeKey" => "@devsegun/shriderider",
                        "experienceId" => "@devsegun/shriderider"
                    ],
                ]
            ]);

            // dd($rr);
            // Log::info('expo request rider error', $response->body());
            // File::append(public_path() . '/static/webhook.txt', "=============================\n\n" . $response->body() . PHP_EOL . "\n=============================");

            $rr = json_decode($response->body());
            if (isset($rr->name)) {
                return true;
            }

            return false;
        } catch (\Throwable $e) {
            report($e);
            return false;
        }
    }

    public function send_webpush($token, $title = '', $message = '', $link, $data = []): bool
    {
        $otoken = SettingsHelper::getObj(null, "oauth_token");

        try {
            $response = Http::withHeaders(
                [
                    'accept' => 'application/json',
                    'authorization' => 'Bearer ' . $otoken->value,
                    'content-type' => 'application/json',
                ]
            )->post("https://fcm.googleapis.com/v1/projects/shrideapp-b2e8a/messages:send", [
                "message" => [
                    "token" => $token,
                    "notification" => [
                        "title" => $title,
                        "body" => $message,
                    ],
                    "webpush" => [
                        "headers" => [
                            "Urgency" => "high"
                        ],
                        "fcm_options" => [
                            "link" => $link
                        ],
                        // "data" => json_encode($data),
                        // "data" => $data,
                    ],
                ]
            ]);


            File::append(public_path() . '/static/webhook.txt', "=============================\n\n webpush noti " . $response->body() . PHP_EOL . "\n=============================");

            $rr = json_decode($response->body());
            // dd(isset($rr->name));
            if (isset($rr->name)) {
                return true;
            } else {
                return false;
            }
        } catch (\Throwable $e) {
            report($e);
            return false;
        }
    }

}
