<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;
use App\Helpers\FilterHelper;
use Psy\Exception\ThrowUpException;

class TermiService
{

    private $headers;
    private $base_url;

    public function __construct()
    {
        $this->headers = [
            'accept' => 'application/json',
            'content-type' => 'application/json',
        ];

        $this->base_url = "https://v3.api.termii.com/api/sms/send";
    }

    public function send_sms($mobile, $msg): bool
    {
        $phone_number =  FilterHelper::fixPhoneNumber($mobile);
        // dd($phone_number);
        try {
            $response = Http::withHeaders($this->headers)->post($this->base_url, [
                "to" => $phone_number,
                // "from" => "Shride",
                "from" => "N-Alert",
                "sms" => $msg,
                "type" => "plain",
                // "channel" => "generic",
                "channel" => "dnd",
                "api_key" => env("TERMI_SMS_API_KEY")
            ]);

            $rr = json_decode($response->body());
            // dd($rr);

            if (isset($rr->statusCode)) {

                // if ($rr->statusCode == 400) {
                return false;
                // }
            }

            return true;
        } catch (\GuzzleHttp\Exception\RequestException $e) {
            report($e);
            // return $e->getResponse()->getReasonPhrase();
            return false;
        } catch (\Throwable $e) {
            report($e);
            return false;
        }
    }
}
