<?php

namespace App\Services;

use App\Models\User;

class WalletService
{

    public function __construct()
    {
    }

    public static function create_customer(User $user)
    {
        if (env("PAYMENT_GATEWAY") == "paystack") {
            $pa = new PaystackService();
            return $pa->create_customer($user);
        }
    }

    public static function create_virtual_account(User $user)
    {
        if (env("PAYMENT_GATEWAY") == "paystack") {
            $pa = new PaystackService();
            if ($user->paystack_customer_code) {
                return $pa->create_virtual_account($user);
            } else {
                $pa->create_customer($user);
                return $pa->create_virtual_account($user);
            }
        }
    }

    public static function resolve_account_number($bank_code, $account_number)
    {
        if (env("PAYMENT_GATEWAY") == "paystack") {
            $pa = new PaystackService();
            return $pa->resolve_account_number($bank_code, $account_number);
        }
    }

    public static function withdraw_rider_funds($rider, $bank, $amount)
    {
        if (env("PAYMENT_GATEWAY") == "paystack") {
            $pa = new PaystackService();
            return $pa->withdraw_rider_funds($rider, $bank, $amount);
        }
    }

    public static function verify_transfer($transfer)
    {
        if ($transfer->gateway_type == "paystack") {
            $pa = new PaystackService();
            return $pa->verify_transfer($transfer->gateway_reference);
        }
    }
}
