<?php

namespace App\View\Components;

use App\Events\TradeUpdatedEvent;
use App\Helpers\FilterHelper;
use App\Models\TopTrader;
use App\Models\Trade;
use App\Models\TradingAccount;
use App\Models\User;
use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class Trades extends Component
{
    public $trader_id;
    /**
     * Create a new component instance.
     */
    public function __construct($traderid = null)
    {
        $this->trader_id = $traderid;
    }

    public function handleTradeComponentForms(Request $request)
    {
        if ($request->has('edit_trade')) {
            Validator::validate($request->all(), [
                'trade_id' => 'required',
                'entry_price' => 'required',
                'trade_action' => 'required',
            ]);

            $t = Trade::find($request->trade_id);
            if ($t) {
                $t->entry_price = FilterHelper::amount($request->entry_price);
                $t->trade_action = $request->trade_action;
                $t->save();

                // other copies
                $copies = Trade::where("source_id", $t->id)->where("source", "copy trade")->get();
                foreach($copies as $c){
                    $c->entry_price = FilterHelper::amount($request->entry_price);
                    $c->trade_action = $request->trade_action;
                    $c->save();
                }

                try {
                    TradeUpdatedEvent::broadcast($t->user_id, []);
                } catch (\Exception) {
                }

                return back()->with('Success', "Operation Successful");
            } else {
                return back()->with('error', "Trade not found");
            }
        }

        if ($request->has('copy_trade')) {

            Validator::validate($request->all(), [
                'entry_price' => 'required',
            ]);


            $t = Trade::find($request->trade_id);
            if ($t) {
                $trader = TradingAccount::find($request->trader_id);
                if (!$trader) {
                    return back()->with('error', "User not found");
                }

               
                $cloned_trade = $t->replicate();
                $cloned_trade->user_id = $trader->user_id;
                $cloned_trade->trader_id = $trader->id;
                $cloned_trade->source = "copy trade";
                $cloned_trade->source_id = $t->id;
                $cloned_trade->copied_username = $request->toptrader_id;
                $cloned_trade->entry_price = FilterHelper::amount($request->entry_price);
                $cloned_trade->close_price = $request->close_price ? FilterHelper::amount($request->close_price) : null;
                $cloned_trade->opened_at = $request->opened_at ? $request->opened_at : null;
                if($t->is_trade_done == 1){
                    
                }

                $cloned_trade->save();

                // try {
                //     TradeUpdatedEvent::broadcast($user->id, []);
                // } catch (\Exception) {
                // }

                return back()->with('Success', "Operation Successful");
            } else {
                return back()->with('error', "Trade not found");
            }
        }

        if ($request->has('delete_trade')) {

            Validator::validate($request, [
                'c_id' => 'required',
            ]);

            $b = Trade::find($request->c_id);
            if ($b) {
                $b->delete();
                return back()->with('success', "Done");
            } else {
                return back()->with('error', "Trade Not Found");
            }
        }
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render()
    {
        if ($this->trader_id) {
            $trader = TradingAccount::find($this->trader_id);
            $user = $trader->user;
            $trades = $trader->trades()->orderBy('id', 'DESC')->get();
        } else {
            $user = null;
            $trades = Trade::orderBy("id", "DESC")->get();
        }

        $toptraders = TopTrader::orderBy('id', 'desc')->get();

        return view('components.trades', [
            'user' => $user,
            'trades' => $trades,
            'toptraders' => $toptraders,
            'trading_accounts' => TradingAccount::orderBy("id", "DESC")->get(),
        ]);
    }
}
