<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_wallet_transactions', function (Blueprint $table) {
            $table->id();
            $table->string("uuid");
            $table->foreignId("user_id");
            $table->bigInteger("amount");
            $table->string("type"); // credit | debit
            $table->string("payment_method")->nullable(); //transfer | card
            $table->string("note")->nullable();
            $table->string("gateway_type")->nullable(); // paystack | flutterwave
            $table->string("gateway_reference")->nullable();
            $table->string("status")->default("pending");
            $table->integer("is_done")->default(0);
            $table->dateTime("created_at")->nullable();
            $table->dateTime("updated_at")->nullable();
            $table->dateTime("deleted_at")->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('wallet_transactions');
    }
};
