<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vehicles', function (Blueprint $table) {
            $table->id();
            $table->foreignId('rider_id');
            $table->string("name");
            $table->string("type"); // bike, keke
            $table->string("model")->nullable();
            $table->string("plate_number");
            $table->string("color");
            $table->longText("front_picture")->nullable();
            $table->longText("back_picture")->nullable();
            $table->text("description")->nullable();
            $table->integer("is_active")->default(0);
            $table->integer("is_blocked")->default(0);
            $table->integer("is_verified")->default(0);
            $table->foreignId("handled_by")->nullable(); //staff id
            $table->dateTime("handled_at")->nullable();
            $table->dateTime("created_at")->nullable();
            $table->dateTime("updated_at")->nullable();
            $table->dateTime("deleted_at")->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rider_vehicles');
    }
};
