<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('promo_codes', function (Blueprint $table) {
            $table->id();
            $table->string("type"); // ride, delivery
            $table->string("name");
            $table->string("code");
            $table->string("description")->nullable();
            $table->string("rule")->nullable(); // first_three_rides
            $table->bigInteger("amount")->default(0);
            $table->string("amount_type")->default("fixed"); // fixed, percentage
            $table->integer("max_usage")->default(1);
            $table->integer("is_active")->default(0);
            $table->dateTime("starts_at")->nullable();
            $table->dateTime("ends_at")->nullable();
            $table->dateTime("created_at")->nullable();
            $table->dateTime("updated_at")->nullable();
            $table->dateTime("deleted_at")->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('promo_codes');
    }
};
