<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('trip_money', function (Blueprint $table) {
            $table->id();
            $table->foreignId("trip_id");
            $table->string("record_is_for"); // user, rider, company
            $table->string("type"); // credit, debit
            $table->string("title");
            $table->bigInteger("amount")->default(0);
            $table->foreignId("user_promo_code_id");
            $table->dateTime("created_at")->nullable();
            $table->dateTime("updated_at")->nullable();
            $table->dateTime("deleted_at")->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('trip_money');
    }
};
