@extends('layouts.admin')
@section('add_js')
    <script type="text/javascript">
        $('#ast-dt').DataTable({
            drawCallback: function() {


                handleOverflowForAllTables();
                bindToggleEvents();
            }
        });
    </script>
@endsection
@section('content')
    <style>
        .form-group {
            margin-bottom: 20px;
        }
    </style>
    <!-- [ Main Content ] start -->
    <div class="row">

        <div class="col-md-12">
            <div class="page-header">
                <div class="page-block">
                    <div class="row align-items-center">

                        <div class="col-md-12">
                            <div class="page-header-title">
                                <h4 class="mb-0">{{ $page_title ?? '' }}</h4>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-12">
            @include('layouts/flash')
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex align-items-center justify-content-between py-3" data-bs-toggle="collapse"
                        data-bs-target="#collapseUi">
                        <h5>Create New</h5>
                        <div class="dropdown">
                            <i style="font-size: 18px;" class="fas fa-caret-down"></i>
                        </div>
                    </div>
                    <div id="collapseUi" class="collapse">
                        <div class="card-body">
                            <form action="" method="POST" enctype="multipart/form-data">
                                {{ csrf_field() }}
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Username *</label>
                                            <input type="text" name="username" class="form-control"
                                                value="{{ old('username') }}">
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Firstname *</label>
                                            <input type="text" name="firstname" class="form-control"
                                                value="{{ old('firstname') }}">
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Lastname</label>
                                            <input type="text" name="lastname" class="form-control"
                                                value="{{ old('lastname') }}">
                                        </div>
                                    </div>

                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>Success Rate *</label>
                                            <input type="text" name="success_rate" class="form-control"
                                                value="{{ old('success_rate') }}">
                                            <p class="">e.g 53%</p>
                                        </div>
                                    </div>

                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>Commission *</label>
                                            <input type="text" name="commision" class="form-control"
                                                value="{{ old('commision') }}">
                                            <p class="">e.g 22%</p>
                                        </div>
                                    </div>

                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>Min Investment Amount *</label>
                                            <input type="text" name="min_investment" class="form-control"
                                                value="{{ old('min_investment') }}">
                                        </div>
                                    </div>

                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>Largest Win *</label>
                                            <input type="text" name="largest_win" class="form-control"
                                                value="{{ old('largest_win') }}">
                                            <p class="">e.g USD 465K</p>
                                        </div>
                                    </div>

                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>Copiers *</label>
                                            <input type="text" name="copiers" class="form-control"
                                                value="{{ old('copiers') }}">
                                            <p class="">e.g 5,000 +</p>
                                        </div>
                                    </div>

                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>All Time ROI *</label>
                                            <input type="text" name="all_time_roi" class="form-control"
                                                value="{{ old('all_time_roi') }}">
                                            <p class="">e.g +9433%</p>
                                        </div>
                                    </div>


                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Profile Picture</label>
                                            <input type="file" name="avatar" class="form-control">
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>About</label>
                                            <textarea name="about" class="form-control">{!! old('about') !!}</textarea>
                                        </div>
                                    </div>

                                    <div class="col-md-12 mt-2">
                                        <h4>Social Links</h4>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Facebook</label>
                                            <input type="url" name="facebook" class="form-control">
                                            <p>e.g https://facebook.com/demoname</p>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Instagram</label>
                                            <input type="url" name="instagram" class="form-control">
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Twitter</label>
                                            <input type="url" name="twitter" class="form-control">
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Whatsapp</label>
                                            <input type="url" name="whatsapp" class="form-control">
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Telegram</label>
                                            <input type="url" name="telegram" class="form-control">
                                        </div>
                                    </div>

                                </div>


                                <div class="form-group mt-2">
                                    <button type="submit" class="btn btn-primary" name="create_trader">Create</button>
                                </div>

                            </form>

                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-12">
            <div class="card table-card">
                <div class="card-header d-flex align-items-center justify-content-between py-3">
                    <h5>All Top Traders</h5>
                    <div class="dropdown">

                    </div>
                </div>
                <div class="card-body table-responsive py-3 px-4">
                    <table id="ast-dt" class="myTable table table-hover table-bordered table-sm nowrap mb-4 mt-3">
                        <thead>
                            <tr class="border-bottom-secondary border-top-1" style="font-size: 11px!important;">
                                <th class="text-nowrap">#</th>
                                <th class="text-nowrap"></th>
                                <th class="text-nowrap">Action</th>
                                <th class="text-nowrap"></th>
                                <th class="text-nowrap">Fullname</th>
                                <th class="text-nowrap">Username</th>
                                <th class="text-wrap">Activated</th>
                                <th class="text-wrap">About</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($traders as $r)
                                <tr class='' style="font-size: 12px;">

                                    <td>
                                        {{ $loop->iteration }}
                                    </td>
                                    <td>
                                        <button class="btn btn-dark btn-sm toggle-btn"
                                            style="padding-top: 0px; padding-bottom: 0px;">+</button>
                                    </td>

                                    <td>
                                        <button class="btn btn-default btn-sm dropdown-toggle" type="button"
                                            data-bs-toggle="dropdown" aria-haspopup="true"
                                            aria-expanded="false">Actions</button>
                                        <div class="dropdown-menu" style="">
                                            <a class="dropdown-item" href="{{ route('admin.toptrader.view', $r->id) }}">View Trader
                                            </a>

                                            <a class="dropdown-item deleteBtn"
                                                data-all="{{ json_encode(['id' => $r->id, 'uuid' => $r->uuid]) }}">
                                                Delete</a>
                                        </div>
                                    </td>
                                    <td>
                                        <a href="{{ $r->avatar_url }}" target="_blank">
                                            <img src="{{ $r->avatar_url }}" width="50" class="avatar" />
                                        </a>
                                    </td>
                                    <td class="capitalize">{{ $r->fullname }}</td>
                                    <td>{{ $r->username }}</td>
                                    <td>{{ $r->is_active == 1 ? 'Activated' : '' }}</td>
                                    <td>{!! $r->about_html !!}</td>

                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>


            </div>
        </div>
    </div>

    <div id="deleteModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Asset</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <form action="" method="POST">
                            {{ csrf_field() }}

                            <div class="form-group mb-3">
                                <p class="">Are you sure?</p>
                                <input type="hidden" name="bot_id" class="">
                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-danger" name="delete_bot">Delete</button>
                            </div>

                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                </div>
            </div>
        </div>
    </div>

    <div id="editModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Bot</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <form action="" method="POST">
                            {{ csrf_field() }}

                            <div class="col-md-12 mb-3">
                                <div class="form-group">
                                    <label>Name</label>
                                    <input type="text" name="name" class="form-control">
                                    <input type="hidden" name="bot_id" class="">
                                </div>
                            </div>

                            <div class="col-md-12 mb-3">
                                <div class="form-group">
                                    <label>Details</label>
                                    <textarea name="details" class="form-control"></textarea>
                                </div>
                            </div>

                            <div class="col-md-12 mb-3">
                                <div class="form-group">
                                    <label>Picture</label>
                                    <input type="file" name="avatar" class="form-control">
                                </div>
                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-danger" name="edit_bot">Update</button>
                            </div>

                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                </div>
            </div>
        </div>
    </div>
@endsection
