@extends('layouts.admin')
@section('add_js')
    <script type="text/javascript">
        $('#ast-dt').DataTable({
            drawCallback: function() {

                $("* .deleteBtn").on("click", function(e) {
                    e.preventDefault();
                    try {
                        var d = $(this).data('all');
                        const modal = new bootstrap.Modal(document.getElementById(
                            'deleteModal'));

                        $("#deleteModal [name='c_id']").val(d.id);


                        modal.show();
                    } catch (err) {
                        alert(err);
                    }
                });

                handleOverflowForAllTables();
                bindToggleEvents();
            }
        });
    </script>
@endsection
@section('content')
    <style>

    </style>
    <!-- [ Main Content ] start -->
    <div class="row">

        <div class="col-md-12">
            <div class="page-header">
                <div class="page-block">
                    <div class="row align-items-center">

                        <div class="col-md-12">
                            <div class="page-header-title mb-3">
                                <a href="{{ route('admin.toptrader') }}" class=""><i style=""
                                        class="fas fa-caret-left"></i> Back to Top Traders</a>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="page-header-title">
                                <h4 class="mb-0">{{ $page_title ?? '' }}</h4>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <!-- [ breadcrumb ] end -->

        <div class="col-md-12">
            @include('layouts/flash')
        </div>

        <div class="row">
            <div class="col-md-4">
                <div class="card">
                    <div class="card-header d-flex align-items-center justify-content-between py-3"
                        data-bs-toggle="collapse" data-bs-target="#collapseUiPic">
                        <h5>Update Picture</h5>
                        <div class="dropdown">
                            <i style="font-size: 18px;" class="fas fa-caret-down"></i>
                        </div>
                    </div>
                    <div id="collapseUiPic" class="">
                        <div class="card-body">

                            <form action="" method="POST" enctype="multipart/form-data">
                                {{ csrf_field() }}
                                <div class="row">
                                    @if ($trader->avatar_url)
                                        <div class="col-md-12">
                                            <img src="{{ $trader->avatar_url }}" width="100" alt="">
                                        </div>
                                    @endif
                                    <div class="col-md-12 mt-2">
                                        <div class="form-group">
                                            <label>Select Picture</label>
                                            <input type="file" name="avatar" class="form-control">
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <button type="submit" class="btn btn-primary"
                                                name="update_picture">Update</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex align-items-center justify-content-between py-3"
                        data-bs-toggle="collapse" data-bs-target="#collapseUi">
                        <h5>Edit Top Trader</h5>
                        <div class="dropdown">
                            <i style="font-size: 18px;" class="fas fa-caret-down"></i>
                        </div>
                    </div>
                    <div id="collapseUi" class="">
                        <div class="card-body">

                            <form action="" method="POST" enctype="multipart/form-data">
                                {{ csrf_field() }}
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Username *</label>
                                            <input type="text" name="username" class="form-control"
                                                value="{{ $trader->username }}">
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Firstname *</label>
                                            <input type="text" name="firstname" class="form-control"
                                                value="{{ $trader->firstname }}">
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Lastname </label>
                                            <input type="text" name="lastname" class="form-control"
                                                value="{{ $trader->lastname }}">
                                        </div>
                                    </div>

                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>Success Rate *</label>
                                            <input type="text" name="success_rate" class="form-control"
                                                value="{{ $trader->success_rate }}">
                                            <p class="">e.g 53%</p>
                                        </div>
                                    </div>

                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>Commission *</label>
                                            <input type="text" name="commision" class="form-control"
                                                value="{{ $trader->commision }}">
                                            <p class="">e.g 22%</p>
                                        </div>
                                    </div>

                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>Min Investment Amount *</label>
                                            <input type="text" name="min_investment" class="form-control"
                                                value="{{ $trader->min_investment }}">
                                        </div>
                                    </div>

                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>Largest Win *</label>
                                            <input type="text" name="largest_win" class="form-control"
                                                value="{{ $trader->largest_win }}">
                                            <p class="">e.g USD 465K</p>
                                        </div>
                                    </div>

                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>Copiers *</label>
                                            <input type="text" name="copiers" class="form-control"
                                                value="{{ $trader->copiers }}">
                                            <p class="">e.g 5,000 +</p>
                                        </div>
                                    </div>

                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>All Time ROI *</label>
                                            <input type="text" name="all_time_roi" class="form-control"
                                                value="{{ $trader->all_time_roi }}">
                                            <p class="">e.g +9433%</p>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>About</label>
                                            <textarea name="about" class="form-control">{!! $trader->about !!}</textarea>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <h4>Social Links</h4>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Facebook</label>
                                            <input type="url" name="facebook" class="form-control"
                                                value="{{ $trader->social_links->facebook ?? '' }}">
                                            <p>e.g https://facebook.com/demoname</p>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Instagram</label>
                                            <input type="url" name="instagram" class="form-control"
                                                value="{{ $trader->social_links->instagram ?? '' }}">
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Twitter</label>
                                            <input type="url" name="twitter" class="form-control"
                                                value="{{ $trader->social_links->twitter ?? '' }}">
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Whatsapp</label>
                                            <input type="url" name="whatsapp" class="form-control"
                                                value="{{ $trader->social_links->whatsapp ?? '' }}">
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Telegram</label>
                                            <input type="url" name="telegram" class="form-control"
                                                value="{{ $trader->social_links->telegram ?? '' }}">
                                        </div>
                                    </div>

                                </div>


                                <div class="form-group">
                                    <button type="submit" class="btn btn-primary" name="update_info">Update</button>
                                </div>

                            </form>
                        </div>
                    </div>
                </div>
            </div>


        </div>

        <div class="col-md-12">
            <div class="card table-card">
                <div class="card-header d-flex align-items-center justify-content-between py-3">
                    <h5>Trade Data</h5>
                    <div class="dropdown">
                        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#tradeDataModal">Add
                            New</button>
                    </div>
                </div>
                <div class="card-body table-responsive py-3 px-4">
                    <table id="ast-dt" class="table table-hover table-bordered table-sm nowrap mb-4 mt-3">
                        <thead>
                            <tr class="border-bottom-secondary border-top-1" style="font-size: 11px!important;">
                                <th class="text-nowrap">#</th>
                                <th class="text-nowrap">Action</th>
                                <th class="text-nowrap">Date</th>
                                <th class="text-nowrap">Total Wins</th>
                                <th class="text-nowrap">Total Loss</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($trader->demos as $r)
                                <tr class='odd gradeX' role="row">
                                    <td>
                                        {{ $loop->iteration }}
                                    </td>

                                    <td>
                                        <button class="btn btn-default btn-sm dropdown-toggle" type="button"
                                            data-bs-toggle="dropdown" aria-haspopup="true"
                                            aria-expanded="false">Actions</button>
                                        <div class="dropdown-menu" style="">

                                            <a class="dropdown-item deleteBtn"
                                                data-all="{{ json_encode(['id' => $r->id]) }}">
                                                Delete</a>
                                        </div>

                                    </td>
                                    <td>{{ $r->demo_date ? date('M Y', strtotime($r->demo_date)) : '' }}</td>
                                    <td>{{ $r->win }}</td>
                                    <td>{{ $r->loss }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>


            </div>
        </div>
    </div>

    <div id="deleteModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Asset</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <form action="" method="POST">
                            {{ csrf_field() }}

                            <div class="form-group mb-3">
                                <p class="">Are you sure?</p>
                                <input type="hidden" name="c_id" class="">
                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-danger" name="delete_data">Delete</button>
                            </div>

                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                </div>
            </div>
        </div>
    </div>

    <div id="tradeDataModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Trade Data</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <form action="" method="POST">
                            {{ csrf_field() }}
                            <div class="form-group">
                                <label>Year</label>
                                <input type="text" name="year" class="form-control" />
                            </div>
                            <div class="form-group">
                                <label>Month</label>
                                <select class="form-control" name="month">
                                    <option value=""></option>
                                    <option value="01">Jan</option>
                                    <option value="02">Feb</option>
                                    <option value="03">Mar</option>
                                    <option value="04">Apr</option>
                                    <option value="05">May</option>
                                    <option value="06">Jun</option>
                                    <option value="07">Jul</option>
                                    <option value="08">Aug</option>
                                    <option value="09">Sept</option>
                                    <option value="10">Oct</option>
                                    <option value="11">Nov</option>
                                    <option value="12">Dec</option>
                                </select>
                            </div>

                            <div class="form-group">
                                <label>Total Wins</label>
                                <input type="text" name="total_wins" class="form-control" />
                            </div>

                            <div class="form-group">
                                <label>Total Loss</label>
                                <input type="text" name="total_loss" class="form-control" />
                            </div>

                            <button type="submit" class="btn btn-primary" name="create_demo">Submit</button>
                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                </div>
            </div>
        </div>
    </div>
@endsection
