@extends('layouts.admin')
@section('add_js')
    <script type="text/javascript">
        $("* .editTradeBtn").on("click", function(e) {
            e.preventDefault();
            try {
                var d = $(this).data('all');
                const modal = new bootstrap.Modal(document.getElementById('editTraderModal'));

                $("#editTraderModal [name='trader_id']").val(d.id);
                $("#editTraderModal [name='balance']").val(d.balance);
                $("#editTraderModal .modal-title").text("Edit Trader Balance: " + d.uuid);

                modal.show();
            } catch (err) {
                alert(err);
            }
        });

        $('#ast-dt').DataTable({
            drawCallback: function() {
                $("* .editBtn").on("click", function(e) {
                    e.preventDefault();
                    try {
                        var d = $(this).data('all');
                        const modal = new bootstrap.Modal(document.getElementById('editModal'));

                        $("#editModal [name='c_id']").val(d.id);
                        $("#editModal [name='market']").val(d.market);
                        $("#editModal [name='base_symbol']").val(d.base_symbol);
                        $("#editModal [name='quote_symbol']").val(d.quote_symbol);
                        $("#editModal [name='current_price']").val(d.current);
                        $("#editModal .modal-title").text("Edit Asset: " + d.symbol);

                        modal.show();
                    } catch (err) {
                        alert(err);
                    }
                });

                $("* .deleteBtn").on("click", function(e) {
                    e.preventDefault();
                    try {
                        var d = $(this).data('all');
                        const modal = new bootstrap.Modal(document.getElementById('deleteAssetModal'));

                        $("#deleteAssetModal [name='c_id']").val(d.id);
                        $("#deleteAssetModal .modal-title").text("Delete Asset: " + d.symbol
                            .toUpperCase());

                        modal.show();
                    } catch (err) {
                        alert(err);
                    }
                });

            }
        });

        $('#ast-dt-copy').DataTable({
            drawCallback: function() {
                $("* .editCopyBtn").on("click", function(e) {
                    e.preventDefault();
                    try {
                        var d = $(this).data('all');
                        const modal = new bootstrap.Modal(document.getElementById('editCopyModal'));

                        $("#editCopyModal [name='c_id']").val(d.id);
                        $("#editCopyModal [name='rule']").val(d.rule);
                        $("#editCopyModal [name='amount']").val(d.amount);
                        $("#editCopyModal [name='status']").val(d.status);

                        modal.show();
                    } catch (err) {
                        alert(err);
                    }
                });

                $("* .deleteCopyBtn").on("click", function(e) {
                    e.preventDefault();
                    try {
                        var d = $(this).data('all');
                        const modal = new bootstrap.Modal(document.getElementById('deleteCopyModal'));

                        $("#deleteCopyModal [name='c_id']").val(d.id);

                        modal.show();
                    } catch (err) {
                        alert(err);
                    }
                });


                handleOverflowForAllTables();
                bindToggleEvents();
            }
        });
    </script>
@endsection
@section('content')
    <style>

    </style>
    <!-- [ Main Content ] start -->
    <div class="row">

        <div class="col-md-12">
            <div class="page-header">
                <div class="page-block">
                    <div class="row align-items-center">

                        <div class="col-md-12">
                            <div class="page-header-title">
                                <h4 class="mb-0">{{ $page_title ?? '' }}</h4>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-12 mb-3">

            <button class="btn btn-dark btn-sm dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-haspopup="true"
                aria-expanded="false">Actions</button>
            <div class="dropdown-menu" style="font-size: 12px;">
                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#toggleLogin">Login User</a>
                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#toggleCopyModal">Toggle Copy</a>
                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#toggleVerifiedModal">Toggle Verified</a>
                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#toggleOpenAcctModal">Toggle Open
                    Account</a>
                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#predModal">Create Multi Predictions</a>
                <a class="dropdown-item" href="{{ route('admin.setting.crypto', $user->id) }}">Manual Crypto Payment
                    Settings</a>
                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#deleteUserModal">Delete</a>

            </div>
        </div>

        <div class="col-md-12">
            @include('layouts/flash')
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="card user-card">
                    <div class="card-body">

                        <a href="{{ $user->avatar_url }}" target="_blank" class="chat-avtar card-user-image mt-1">
                            <img src="{{ $user->avatar_url }}" alt="user-image" class="img-thumbnail rounded-circle"
                                style="height: 100px; width: 100px;">
                            <i class="chat-badge bg-success"></i>
                        </a>
                        <div class="d-flex flex-wrap gap-2 mt-0">
                            <div class="flex-grow-1">
                                <h6 class="mb-1 text-capitalize">{{ $user->fullname }}</h6>
                                <p class="text-muted text-sm mb-0">{{ $user->email }}</p>
                            </div>
                            <div class="flex-shrink-0">
                                <button class="btn btn-primary btn-sm">Message</button>
                                <button class="btn btn-outline-secondary btn-sm ms-1">Follow</button>
                            </div>
                        </div>
                        <div class="row g-3">
                            <div class="col-md-12">
                                <div class="saprator my-3 mb-0">
                                    <span>Trading Accounts</span>
                                </div>
                            </div>
                            <div class="col-md-12">
                                @foreach ($user->trading_accounts as $t)
                                    <div class="d-flex flex-wrap gap-2 mb-3">
                                        <div class="flex-grow-1">
                                            <h6 class="mb-1 text-capitalize">{{ $t->type }} #{{ $t->uuid }}</h6>
                                            <p class="text-muted text-uppercase text-sm mb-0"><span
                                                    class="digits">{{ $t->balance }}</span> {{ $t->currency }}</p>
                                        </div>
                                        <div class="flex-shrink-0">
                                            {{-- <button class="btn btn-primary btn-sm editTradeBtn"
                                                data-all="{{ json_encode($t) }}">Edit</button> --}}
                                            <a class="btn btn-outline-secondary btn-sm ms-1"
                                                href="{{ route('admin.user.trader', $t->id) }}">Open</a>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="card">
                    <div class="card-header" style="padding-bottom: 5px; padding-top: 10px;">
                        <div class="d-flex flex-wrap gap-2 mt-0">
                            <div class="flex-grow-1">
                                <h6>User Details</h6>
                            </div>
                            <div class="">
                                <i style="font-size: 18px;" class="fas fa-caret-down" data-bs-toggle="collapse"
                                    data-bs-target="#collapseUi"></i>
                            </div>
                        </div>
                    </div>
                    <div class="" id="collapseUi">
                        <div class="card-body">
                            <div class="row g-3">
                                <div class="col-6">

                                    <div class="">
                                        <h6 class="mb-0 text-capitalize">Firstname</h6>
                                        <p class="text-capitalize text-sm mb-0">{{ $user->firstname }}</p>
                                    </div>
                                    <div class="mt-2">
                                        <h6 class="mb-0 text-capitalize">Lastname</h6>
                                        <p class="text-capitalize text-sm mb-0">{{ $user->lastname }}</p>
                                    </div>
                                    <div class="mt-2">
                                        <h6 class="mb-0 text-capitalize">Email</h6>
                                        <p class="text-sm mb-0">{{ $user->email }}</p>
                                    </div>
                                    <div class="mt-2">
                                        <h6 class="mb-0 text-capitalize">Password</h6>
                                        <p class="text-sm mb-0">{{ $user->password }}</p>
                                    </div>
                                    <div class="mt-2">
                                        <h6 class="mb-0 text-capitalize">Phone Number</h6>
                                        <p class="text-sm mb-0">{{ $user->mobile }}</p>
                                    </div>
                                    <div class="mt-2">
                                        <h6 class="mb-0 text-capitalize">Verified</h6>
                                        <p class="text-sm mb-0">{{ $user->is_verified == 1 ? 'YES' : 'NO' }}</p>
                                    </div>
                                    <div class="mt-2">
                                        <h6 class="mb-0 text-capitalize">2FA Type</h6>
                                        <p class="text-sm mb-0">{{ $user->twofa_type }}</p>
                                    </div>
                                    <div class="mt-2">
                                        <h6 class="mb-0 text-capitalize">2FA Code</h6>
                                        <p class="text-sm mb-0">{{ $user->twofa_code }}</p>
                                    </div>
                                    <div class="mt-2">
                                        <h6 class="mb-0 text-capitalize">Google Secret Code</h6>
                                        <p class="text-sm mb-0">{{ $user->google2fa_secret }}</p>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="">
                                        <h6 class="mb-0 text-capitalize">Plan</h6>
                                        <p class="text-capitalize text-sm mb-0">{{ $user->plan->title ?? '' }}</p>
                                    </div>
                                    <div class="mt-2">
                                        <h6 class="mb-0 text-capitalize">Country</h6>
                                        <p class="text-sm mb-0">{{ $user->country }}</p>
                                    </div>
                                    <div class="mt-2">
                                        <h6 class="mb-0 text-capitalize">Password</h6>
                                        <p class="text-sm mb-0">{{ $user->password }}</p>
                                    </div>
                                    <div class="mt-2">
                                        <h6 class="mb-0 text-capitalize">Blocked</h6>
                                        <p class="text-sm mb-0">{{ $user->is_blocked == 1 ? 'YES' : 'NO' }}</p>
                                    </div>
                                    <div class="mt-2">
                                        <h6 class="mb-0 text-capitalize">Copy Trade Access</h6>
                                        <p class="text-sm mb-0">{{ $user->can_copy == 1 ? 'YES' : 'NO' }}</p>
                                    </div>
                                    <div class="mt-2">
                                        <h6 class="mb-0 text-capitalize">Open Account Access</h6>
                                        <p class="text-sm mb-0">{{ $user->can_open_account == 1 ? 'YES' : 'NO' }}</p>
                                    </div>

                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="card table-card">
                    <div class="card-header d-flex align-items-center justify-content-between py-3">
                        <h5>Trade Predictions ({{ $user?->trade_predictions->count() }})</h5>
                        <div class="dropdown">

                        </div>
                    </div>
                    <div class="card-body table-responsive py-3 px-4">
                        <div class="mb-3">
                            <button class="btn btn-dark" data-bs-toggle="modal" data-bs-target="#copyPredModal">Copy
                                Text</button>
                        </div>
                        <table id="ast-dt" class="myTable table table-hover table-bordered table-sm nowrap mb-4 mt-3">
                            <thead>
                                <tr class="border-bottom-secondary border-top-1" style="font-size: 11px!important;">
                                    <th scope="col">S/N</th>
                                    <th scope="col"></th>
                                    <th scope="col"></th>
                                    <th scope="col">ID</th>
                                    <th scope="col">Symbol</th>
                                    <th scope="col">Market</th>
                                    <th scope="col">Amount</th>
                                    <th scope="col">Entry Price</th>
                                    <th scope="col">Action</th>
                                    <th scope="col">Used</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($user->trade_predictions()->orderBy('id', 'DESC')->get() as $r)
                                    <tr class="" style="font-size: 12px;">
                                        <td>
                                            {{ $loop->iteration }}
                                        </td>
                                        <td>
                                            <button class="btn btn-dark btn-sm toggle-btn"
                                                style="padding-top: 0px; padding-bottom: 0px;">+</button>
                                        </td>

                                        <td style="">

                                            <button class="btn btn-default btn-sm dropdown-toggle" type="button"
                                                data-bs-toggle="dropdown" aria-haspopup="true"
                                                aria-expanded="false">Actions</button>
                                            <div class="dropdown-menu" style="">
                                                <a class="dropdown-item editBtn" data-all="{{ json_encode($r) }}">Edit
                                                </a>

                                                <a class="dropdown-item deleteBtn"
                                                    data-all="{{ json_encode(['id' => $r->id]) }}">
                                                    Delete</a>
                                            </div>

                                        </td>

                                        <td class="">{{ $r->uuid }}</td>
                                        <td class="uppercase">{{ $r->symbol }}</td>
                                        <td>{{ $r->market }}</td>
                                        <td class="text-uppercase">{{ $r->amount }}</td>
                                        <td>{{ $r->entry_price }}</td>
                                        <td>{{ $r->fmt_trade_action }}</td>
                                        <td class="">{{ $r->is_trade_done == 1 ? 'YES' : 'NO' }}</td>
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>


                </div>
            </div>

            <div class="col-md-12">
                <div class="card table-card">
                    <div class="card-header d-flex align-items-center justify-content-between py-3"
                        data-bs-toggle="collapse" data-bs-target="#collapseCopy">
                        <h5>Copy Trading ({{ $user?->user_copy_traders->count() }})</h5>
                        <div class="dropdown">
                            <i style="font-size: 18px;" class="fas fa-caret-down"></i>
                        </div>
                    </div>
                    <div id="collapseCopy">
                        <div class="card-body table-responsive py-3 px-4">
                            <div class="mb-3">
                                <button class="btn btn-dark btn-sm" data-bs-toggle="modal"
                                    data-bs-target="#addCopyModal">Activate New Copy Trading
                                </button>
                            </div>
                            <table id="ast-dt-copy"
                                class="myTable table table-hover table-bordered table-sm nowrap mb-4 mt-3">
                                <thead>
                                    <tr class="border-bottom-secondary border-top-1" style="font-size: 11px!important;">
                                        <th scope="col">S/N</th>
                                        <th scope="col"></th>
                                        <th scope="col"></th>
                                        <th scope="col">Trader</th>
                                        <th scope="col">Rule</th>
                                        <th scope="col">Amount</th>
                                        <th scope="col">Status</th>
                                </thead>
                                <tbody>
                                    @foreach ($user->user_copy_traders()->orderBy('id', 'DESC')->get() as $r)
                                        <tr class="" style="font-size: 12px;">
                                            <td>
                                                {{ $loop->iteration }}
                                            </td>
                                            <td>
                                                <button class="btn btn-dark btn-sm toggle-btn"
                                                    style="padding-top: 0px; padding-bottom: 0px;">+</button>
                                            </td>

                                            <td style="">

                                                <button class="btn btn-default btn-sm dropdown-toggle" type="button"
                                                    data-bs-toggle="dropdown" aria-haspopup="true"
                                                    aria-expanded="false">Actions</button>
                                                <div class="dropdown-menu" style="">
                                                    <a class="dropdown-item editCopyBtn"
                                                        data-all="{{ json_encode($r) }}">Edit

                                                    </a>

                                                    <a class="dropdown-item deleteCopyBtn"
                                                        data-all="{{ json_encode(['id' => $r->id]) }}">
                                                        Delete</a>
                                                </div>

                                            </td>

                                            <td class="">
                                                <a target="_blank"
                                                    href="{{ route('admin.toptrader.view', $r->toptrader_id) }}"
                                                    class="text-uppercase">
                                                    {{ $r->trader?->fullname }}
                                                </a>
                                            </td>
                                            <td class="uppercase">{{ $r->rule }}</td>
                                            <td class="text-uppercase">{{ $r->amount }}</td>
                                            <td class="">{{ $r->status }}</td>
                                        </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                    </div>

                </div>
            </div>

            <div class="col-md-12">
                <div class="card table-card">
                    <div class="card-header d-flex align-items-center justify-content-between py-3"
                        data-bs-toggle="collapse" data-bs-target="#collapseCopy">
                        <h5>KYC Uploads</h5>
                        <div class="dropdown">
                            <i style="font-size: 18px;" class="fas fa-caret-down"></i>
                        </div>
                    </div>
                    <div id="collapseCopy">
                        <div class="card-body table-responsive py-3 px-4">

                            <table id="" class="table table-hover table-bordered table-sm nowrap mb-4 mt-3">
                                <thead>
                                    <tr class="border-bottom-secondary border-top-1" style="font-size: 11px!important;">
                                        <th scope="col">S/N</th>
                                        <th scope="col"></th>
                                        <th scope="col">Type</th>
                                        <th scope="col">Front</th>
                                        <th scope="col">Back</th>
                                </thead>
                                <tbody>
                                    @foreach ($user->ids()->orderBy('id', 'DESC')->get() as $r)
                                        <tr class="" style="font-size: 12px;">
                                            <td>
                                                {{ $loop->iteration }}
                                            </td>
                                          

                                            <td style="">

                                                <button class="btn btn-default btn-sm dropdown-toggle" type="button"
                                                    data-bs-toggle="dropdown" aria-haspopup="true"
                                                    aria-expanded="false">Actions</button>
                                                <div class="dropdown-menu" style="">

                                                </div>

                                            </td>
                                            <td class="uppercase">{{ $r->id_type }}</td>
                                            <td class="">
                                                <a target="_blank" href="{{ $r->front_url }}" class="text-uppercase">
                                                    Front
                                                </a>
                                            </td>
                                            <td class="">
                                                <a target="_blank" href="{{ $r->back_url }}" class="text-uppercase">
                                                    Back
                                                </a>
                                            </td>

                                        </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <div id="deleteUserModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete User</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <form action="" method="POST">
                            {{ csrf_field() }}
                            <div class="form-group mb-3">
                                <p class="">Are you sure?</p>
                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-danger" name="delete_user">Delete</button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                </div>
            </div>
        </div>
    </div>

    <div id="toggleLogin" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Login User</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <form action="" method="POST">
                            {{ csrf_field() }}
                            <div class="form-group mb-3">
                                <p class="">Are you sure?</p>
                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-danger" name="quick_login">Continue</button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                </div>
            </div>
        </div>
    </div>

    <div id="toggleCopyModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Toggle Copy</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <form action="" method="POST">
                            {{ csrf_field() }}
                            <div class="form-group mb-3">
                                <p class="">Are you sure?</p>
                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-danger" name="toggle_copy">Continue</button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                </div>
            </div>
        </div>
    </div>

    <div id="toggleOpenAcctModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Toggle Copy</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <form action="" method="POST">
                            {{ csrf_field() }}
                            <div class="form-group mb-3">
                                <p class="">Are you sure?</p>
                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-danger"
                                    name="toggle_open_account">Continue</button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                </div>
            </div>
        </div>
    </div>

    <div id="toggleVerifiedModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Toggle Verified</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <form action="" method="POST">
                            {{ csrf_field() }}
                            <div class="form-group mb-3">
                                <p class="">Are you sure?</p>
                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-danger" name="toggle_verified">Continue</button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                </div>
            </div>
        </div>
    </div>

    <div id="editTraderModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Trader Balance</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <form action="" method="POST">
                            {{ csrf_field() }}

                            <div class="form-group mb-3">
                                <label for="">Balance</label>
                                <input type="text" name="balance" class="form-control">
                                <input type="hidden" name="trader_id">
                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-danger" name="edit_trader">Update</button>
                            </div>

                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                </div>
            </div>
        </div>
    </div>

    <div id="predModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Create Predictions</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <form action="" method="POST">
                            {{ csrf_field() }}

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <div class="form-group">
                                        <label>Market</label>
                                        <select class="form-control" name="market">
                                            <option>------</option>
                                            @foreach (App\Models\Market::orderBy('id', 'DESC')->get() as $r)
                                                <option value="{{ strtolower($r->name) }}">{{ strtolower($r->name) }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <div class="form-group">
                                        <label>Minimum Amount (USD)</label>
                                        <input type="text" name="min_amount" class="form-control">
                                    </div>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <div class="form-group">
                                        <label>Maximum Amount (USD)</label>
                                        <input type="text" name="max_amount" class="form-control">
                                    </div>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <div class="form-group">
                                        <label>Trade Type</label>
                                        <select class="form-control" name="trade_type">
                                            <option value="live">Live</option>
                                            <option value="demo">Demo</option>
                                        </select>
                                    </div>
                                </div>


                                <div class="col-md-6 mb-3">
                                    <div class="form-group">
                                        <label>Number Of Predictions</label>
                                        <select class="form-control" name="num_of_predictions">
                                            <option value="1">1</option>
                                            <option value="2">2</option>
                                            <option value="3">3</option>
                                            <option value="4">4</option>
                                            <option value="5">5</option>
                                            <option value="6">6</option>
                                            <option value="7">7</option>
                                            <option value="8">8</option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-danger"
                                    name="create_mul_predictions">Submit</button>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="copyPredModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Copy Prediction Text</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <h6 class="mb-2">Action | Amount | Market | Symbol | Entry Price</h6>
                            @foreach ($user->trade_predictions as $r)
                                @if ($r->done == 0)
                                    <p>{{ $r->fmt_trade_action }} | {{ $r->amount }} | {{ $r->market }} |
                                        {{ $r->symbol }}
                                        | {{ $r->entry_price }}</p>
                                @endif
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="deleteCopyModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Copy Trading</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <form action="" method="POST">
                            {{ csrf_field() }}
                            <div class="form-group mb-3">
                                <p class="">Are you sure?</p>
                            </div>

                            <div class="form-group">
                                <input type="hidden" name="c_id">
                                <button type="submit" class="btn btn-danger" name="delete_copy_trading">Delete</button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                </div>
            </div>
        </div>
    </div>

    <div id="editCopyModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Copy Trading</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <form action="" method="POST">
                            {{ csrf_field() }}

                            <div class="form-group">
                                <label for="">Rule</label>
                                <select name="rule" class="form-control">
                                    <option value="percentage">percentage</option>
                                    <option value="amount">amount</option>
                                </select>
                            </div>

                            <div class="form-group">
                                <label for="">Amount</label>
                                <input type="text" name="amount" class="form-control">
                            </div>

                            <div class="form-group">
                                <label for="">Status</label>
                                <select name="status" class="form-control">
                                    <option value="pending">pending</option>
                                    <option value="activated">activated</option>
                                </select>
                            </div>

                            <div class="form-group">
                                <input type="hidden" name="c_id">
                                <button type="submit" class="btn btn-danger" name="edit_copy_trading">Update</button>
                            </div>

                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                </div>
            </div>
        </div>
    </div>

    <div id="addCopyModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add Copy Trading</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <form action="" method="POST">
                            {{ csrf_field() }}

                            <div class="form-group">
                                <label for="">Select Top Trader</label>
                                <select name="toptrader_id" class="form-control">
                                    @foreach ($toptraders as $t)
                                        <option value="{{ $t->id }}">{{ $t->fullname }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group">
                                <label for="">Rule</label>
                                <select name="rule" class="form-control">
                                    <option value="percentage">percentage</option>
                                    <option value="amount">amount</option>
                                </select>
                            </div>

                            <div class="form-group">
                                <label for="">Amount</label>
                                <input type="text" name="amount" class="form-control">
                            </div>

                            <div class="form-group">
                                <label for="">Status</label>
                                <select name="status" class="form-control">
                                    <option value="pending">pending</option>
                                    <option value="activated">activated</option>
                                </select>
                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-danger" name="add_copy_trading">Submit</button>
                            </div>

                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
@endsection
