<div>

    <script type="text/javascript">
        $(document).ready(function() {
            $('#ast-dt-deps').DataTable({
                drawCallback: function() {
                    $("* .editDepositBtn").on("click", function(e) {

                        e.preventDefault();
                        try {
                            var d = $(this).data('all');
                            const modal = new bootstrap.Modal(document.getElementById(
                                'editDepositModal'));

                            $("#editDepositModal [name='c_id']").val(d.id);
                            $("#editDepositModal [name='status']").val(d.status);
                            $("#editDepositModal .modal-title").text("Edit Deposit: " + d.uuid);

                            modal.show();
                        } catch (err) {
                            alert(err);
                        }
                    });

                    $("* .deleteDepositBtn").on("click", function(e) {
                        e.preventDefault();
                        try {
                            var d = $(this).data('all');
                            const modal = new bootstrap.Modal(document.getElementById(
                                'deleteDepositModal'));

                            // $("#deleteDepositModal [name='c_id']").val(d.id);
                            // $("#deleteDepositModal .modal-title").text("Delete Deposit: " + d
                            //     .uuid);

                            modal.show();
                        } catch (err) {
                            alert(err);
                        }
                    });

                    handleOverflowForAllTablesCustom("flowTable-deps");
                    bindToggleEventsCustom("tgdx-deps");

                }
            });
        });
    </script>
    
    <table id="ast-dt-deps" class="flowTable-deps table table-hover table-bordered table-sm nowrap mb-4 mt-3">
        <thead>
            <tr class="border-bottom-secondary border-top-1" style="font-size: 11px!important;">
                <th scope="col">S/N</th>
                <th scope="col"></th>
                <th scope="col"></th>
                <th scope="col">ID</th>
                @if (!$user)
                    <th scope="col">User</th>
                @endif
                <th scope="col">Amount</th>
                <th scope="col">Method</th>
                <th scope="col">Address</th>
                <th scope="col">Type</th>
                <th scope="col">Status</th>
                <th scope="col">Date</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($deposits as $r)
                <tr class="" style="font-size: 12px;">
                    <td>
                        {{ $loop->iteration }}
                    </td>
                    <td>
                        <button class="btn btn-dark btn-sm tgdx-deps"
                            style="padding-top: 0px; padding-bottom: 0px;">+</button>
                    </td>

                    <td style="">

                        <button class="btn btn-default btn-sm dropdown-toggle" type="button" data-bs-toggle="dropdown"
                            aria-haspopup="true" aria-expanded="false">Actions</button>
                        <div class="dropdown-menu" style="">
                            <a class="dropdown-item editDepositBtn" data-all="{{ json_encode($r) }}">Edit
                                Status
                            </a>

                            <a class="dropdown-item deleteDepositBtn"
                                data-all="{{ json_encode($r) }}">
                                Delete</a>
                        </div>

                    </td>

                    <td class="">{{ $r->uuid }}</td>
                    @if (!$user)
                        <td class="capitalize">
                            <a target="_blank" href="{{ route('admin.user.trader', $r->trader_id ?? '') }}" class="">
                                {{ $r->user?->fullname }}
                            </a>

                        </td>
                    @endif

                    <td class="digits text-uppercase">{{ $r->amount }} {{ $r->currency }}</td>
                    <td>{{ $r->method }}</td>
                    <td>
                        {{ $r->address }}
                        @if ($r->receipt_url)
                            <br />
                            <a href="{{ $r->receipt_url }}" target="_blank">View Receipt</a>
                        @endif
                    </td>
                    <td>{{ $r->type }}</td>
                    <td>
                        @if ($r->status == 'confirmed')
                            <span style="color: green;">Confirmed</span>
                        @else
                            <span style="color: red;">{{ $r->status }}</span>
                        @endif
                    <td>{{ $r->created_at }}</td>
                </tr>
            @endforeach

        </tbody>
    </table>

    <div id="deleteDepositeModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Deposit</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <form action="{{ route('admin.component.deposits') }}" method="POST">
                            {{ csrf_field() }}

                            <div class="form-group mb-3">
                                <p class="">Are you sure?</p>
                                <input type="hidden" name="c_id" class="form-control">
                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-danger" name="delete_deposit">Delete</button>
                            </div>

                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                </div>
            </div>
        </div>
    </div>

    <div id="editDepositModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Deposit</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <form action="{{ route('admin.component.deposits') }}" method="POST">
                            {{ csrf_field() }}

                            <div class="form-group">
                                <label for="">Status</label>
                                <br />
                                <select name="status" class="form-control">
                                    <option value="pending">pending</option>
                                    <option value="failed">failed</option>
                                    <option value="confirmed">confirmed</option>
                                </select>
                            </div>


                            <div class="form-group">
                                <input type="hidden" name="c_id">
                                <button type="submit" class="btn btn-danger" name="edit_deposit">Update</button>
                            </div>

                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                </div>
            </div>
        </div>
    </div>

   
</div>
