<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Web\Current\Admin\{
    UserController,
    DashboardController, AssetController, TradeController
};
use App\View\Components\Trades;
use App\View\Components\Deposits;

Route::any('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
Route::any('/crypto-payment-settings/{user_id}', [DashboardController::class, 'crypto_payment_settings'])->name('setting.crypto');
Route::any('/users', [UserController::class, 'index'])->name('user');
Route::any('/deposits', [DashboardController::class, 'deposits'])->name('deposit');
Route::any('/withdrawals', [DashboardController::class, 'withdrawals'])->name('withdrawal');
Route::any('/assets', [AssetController::class, 'index'])->name('asset');
Route::any('/trades', [TradeController::class, 'index'])->name('trade');
Route::any('/toptraders', [TradeController::class, 'toptraders'])->name('toptrader');
Route::any('/toptrader/{trader_id}', [TradeController::class, 'view_toptrader'])->name('toptrader.view');
Route::any('/tradebots', [TradeController::class, 'tradebots'])->name('tradebot');
Route::any('/user/{user_id}', [UserController::class, 'view_user'])->name('user.view');
Route::any('/trader/{trader_id}', [UserController::class, 'view_trader'])->name('user.trader');
Route::any('/plans', [DashboardController::class, 'plans'])->name('plan');
Route::any('/settings', [DashboardController::class, 'settings'])->name('setting');
Route::any('/settings/payment', [DashboardController::class, 'settings_payment'])->name('setting.payment');

Route::post('/component/trades', [Trades::class, 'handleTradeComponentForms'])->name('component.trades');
Route::post('/component/deposits', [Deposits::class, 'handleComponentForms'])->name('component.deposits');
Route::post('/component/withdrawals', [Deposits::class, 'handleComponentForms'])->name('component.withdrawals');