<?php $__env->startSection('add_js'); ?>
    <script type="text/javascript">
        $('#ast-dt-bot').DataTable({
            drawCallback: function() {
                $("* .deleteBotBtn").on("click", function(e) {
                    e.preventDefault();
                    try {
                        var d = $(this).data('all');
                        const modal = new bootstrap.Modal(document.getElementById('deleteBotModal'));

                        $("#deleteBotModal [name='bot_id']").val(d.id);

                        modal.show();
                    } catch (err) {
                        alert(err);
                    }
                });

                // handleOverflowForAllTables();
                // bindToggleEvents();
            }
        });
    </script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <style>

    </style>
    <!-- [ Main Content ] start -->
    <div class="row">

        <div class="col-md-12 mb-3">

            <button class="btn btn-dark btn-sm dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-haspopup="true"
                aria-expanded="false">Actions</button>
            <div class="dropdown-menu" style="">
                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#balanceModal">Edit Account</a>
                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#toggleActiveModal">Toggle Active</a>
                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#addBotModal">Add Trading Bot</a>

            </div>
        </div>

        <div class="col-md-12">
            <?php echo $__env->make('layouts/flash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="card user-card">
                    <div class="card-body">

                        <div class="chat-avtar card-user-image">
                            <img src="<?php echo e($user->avatar_url ?? ''); ?>" alt="user-image" class="img-thumbnail rounded-circle">
                            <i class="chat-badge bg-success"></i>
                        </div>
                        <div class="d-flex flex-wrap gap-2 mt-0">
                            <div class="flex-grow-1">
                                <h6 class="mb-1 text-capitalize"><?php echo e($user->fullname); ?></h6>
                                <p class="text-muted text-sm mb-0"><?php echo e($user->email); ?></p>
                            </div>
                            <div class="flex-shrink-0">
                                <a href="<?php echo e(route('admin.user.view', $trader->user_id)); ?>"
                                    class="btn btn-outline-secondary btn-sm ms-1">View</a>
                            </div>
                        </div>
                        <div class="row g-3">
                            <div class="col-md-12">
                                <div class="saprator my-3 mb-0">
                                    <span>Trading Account</span>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="d-flex flex-wrap gap-2 mb-3">
                                    <div class="flex-grow-1">
                                        <h6 class="mb-1 text-uppercase"><span class="digits"><?php echo e($trader->balance); ?></span>
                                            <?php echo e($trader->currency); ?></h6>
                                        <p class="text-muted text-uppercase text-sm mb-0"><?php echo e($trader->type); ?>

                                            #<?php echo e($trader->uuid); ?></p>
                                    </div>
                                    <div class="flex-shrink-0">

                                    </div>
                                </div>
                                <div class="">
                                    <p class="text-sm mb-0">
                                        Activated: <?php echo e($trader->is_active == 1 ? 'Yes' : 'NO'); ?></p>
                                </div>

                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-12">
            <div class="card table-card">
                <div class="card-header d-flex align-items-center justify-content-between py-3" data-bs-toggle="collapse"
                    data-bs-target="#collapseTrades">
                    <h5>All Trades (<?php echo e($trader->trades->count()); ?>)</h5>
                    <div class="dropdown">
                        <i style="font-size: 18px;" class="fas fa-caret-down"></i>
                    </div>
                </div>
                <div id="collapseTrades">
                    <div class="card-body table-responsive py-3 px-4">
                        <?php if (isset($component)) { $__componentOriginal523edab875667d1458da8986ba7c68d6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal523edab875667d1458da8986ba7c68d6 = $attributes; } ?>
<?php $component = App\View\Components\Trades::resolve(['traderid' => $trader->id] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('trades'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Trades::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal523edab875667d1458da8986ba7c68d6)): ?>
<?php $attributes = $__attributesOriginal523edab875667d1458da8986ba7c68d6; ?>
<?php unset($__attributesOriginal523edab875667d1458da8986ba7c68d6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal523edab875667d1458da8986ba7c68d6)): ?>
<?php $component = $__componentOriginal523edab875667d1458da8986ba7c68d6; ?>
<?php unset($__componentOriginal523edab875667d1458da8986ba7c68d6); ?>
<?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-12">
            <div class="card table-card">
                <div data-bs-toggle="collapse" data-bs-target="#collapseDeps"
                    class="card-header d-flex align-items-center justify-content-between py-3">
                    <h5>Deposits (<?php echo e($trader->deposits->count()); ?>)</h5>
                    <div class="dropdown">
                        <i style="font-size: 18px;" class="fas fa-caret-down"></i>
                    </div>
                </div>
                <div id="collapseDeps">
                    <div class="card-body table-responsive py-3 px-4">
                        <?php if (isset($component)) { $__componentOriginala7e0a36ff27c28d27746eb8c6a1fa4f7 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginala7e0a36ff27c28d27746eb8c6a1fa4f7 = $attributes; } ?>
<?php $component = App\View\Components\Deposits::resolve(['traderid' => $trader->id] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('deposits'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Deposits::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginala7e0a36ff27c28d27746eb8c6a1fa4f7)): ?>
<?php $attributes = $__attributesOriginala7e0a36ff27c28d27746eb8c6a1fa4f7; ?>
<?php unset($__attributesOriginala7e0a36ff27c28d27746eb8c6a1fa4f7); ?>
<?php endif; ?>
<?php if (isset($__componentOriginala7e0a36ff27c28d27746eb8c6a1fa4f7)): ?>
<?php $component = $__componentOriginala7e0a36ff27c28d27746eb8c6a1fa4f7; ?>
<?php unset($__componentOriginala7e0a36ff27c28d27746eb8c6a1fa4f7); ?>
<?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-12">
            <div class="card table-card">
                <div class="card-header d-flex align-items-center justify-content-between py-3">
                    <h5>Trade Bots (<?php echo e($trader?->bots->count()); ?>)</h5>
                    <div class="dropdown">

                    </div>
                </div>
                <div class="card-body table-responsive py-3 px-4">
                    <table id="ast-dt-bot" class="myTable table table-hover table-bordered table-sm nowrap mb-4 mt-3">
                        <thead>
                            <tr class="border-bottom-secondary border-top-1" style="font-size: 11px!important;">
                                <th scope="col">S/N</th>
                                <th scope="col"></th>
                                <th scope="col"></th>
                                <th scope="col">Bot</th>
                                <th scope="col">Key</th>
                                <th scope="col">Activated</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $trader?->bots()->orderBy('id', 'DESC')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="" style="font-size: 12px;">
                                    <td>
                                        <?php echo e($loop->iteration); ?>

                                    </td>
                                    <td>
                                        
                                        <button class="btn btn-dark btn-sm toggle-btn"
                                            style="padding-top: 0px; padding-bottom: 0px;">+</button>
                                    </td>

                                    <td style="">

                                        <button class="btn btn-default btn-sm dropdown-toggle" type="button"
                                            data-bs-toggle="dropdown" aria-haspopup="true"
                                            aria-expanded="false">Actions</button>
                                        <div class="dropdown-menu" style="">
                                            
                                            <a class="dropdown-item deleteBotBtn"
                                                data-all="<?php echo e(json_encode(['id' => $r->id])); ?>">
                                                Delete</a>
                                        </div>

                                    </td>

                                    <td class=""><?php echo e($r?->bot?->name); ?></td>
                                    <td><?php echo e($r->l_key); ?></td>
                                    <td><?php echo e($r->is_active == 1 ? 'Yes' : 'No'); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                    </table>
                </div>


            </div>
        </div>
    </div>

    <div id="balanceModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Trader Balance</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <form action="" method="POST">
                            <?php echo e(csrf_field()); ?>


                            <div class="form-group mb-3">
                                <label for="">Balance</label>
                                <input type="text" name="balance" class="form-control"
                                    value="<?php echo e($trader->balance); ?>">
                            </div>

                            <div class="form-group mb-3">
                                <label for="">Account Type</label>
                                <select name="account_type" class="form-control">
                                    <option value="<?php echo e($trader->type); ?>"><?php echo e($trader->type); ?></option>
                                    <option value="<?php echo e($trader->type); ?>">---------------------------</option>
                                    <option value="live">live</option>
                                    <option value="demo">demo </option>



                                </select>
                            </div>

                            <div class="form-group mb-3">
                                <label for="">Account Currency</label>
                                <select name="currency" class="form-control">
                                    <option value="<?php echo e($trader->currency); ?>"><?php echo e($trader->currency); ?></option>
                                    <option value="<?php echo e($trader->currency); ?>">---------------------------</option>
                                    <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($c); ?>"><?php echo e($c); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-danger" name="edit_account">Update</button>
                            </div>

                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                </div>
            </div>
        </div>
    </div>

    <div id="toggleActiveModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Toggle Active</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <form action="" method="POST">
                            <?php echo e(csrf_field()); ?>


                            <div class="form-group mb-3">
                                <p class="">Are you sure?</p>
                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-danger" name="toggle_active">Yes</button>
                            </div>

                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                </div>
            </div>
        </div>
    </div>

    <div id="addBotModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add Trading Bot</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <form action="" method="POST">
                            <?php echo e(csrf_field()); ?>


                            <div class="form-group mb-3">
                                <label for="">Select Bot</label>
                                <select name="bot_id" class="form-control">
                                    <option value=""></option>
                                    <?php $__currentLoopData = $bots; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($b->id); ?>"><?php echo e($b->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-danger" name="add_bot">Submit</button>
                            </div>

                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                </div>
            </div>
        </div>
    </div>

    <div id="deleteBotModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Bot</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <form action="" method="POST">
                            <?php echo e(csrf_field()); ?>


                            <div class="form-group mb-3">
                                <p class="">Are you sure?</p>
                                <input type="hidden" name="bot_id" class="form-control">
                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-danger" name="delete_bot">Delete</button>
                            </div>

                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nlgasisc/phoenixfundlimited.com/port/resources/views/admin/view_trader.blade.php ENDPATH**/ ?>