<?php $__env->startSection('add_js'); ?>
    <script type="text/javascript">
        $('#ast-dt').DataTable({
            drawCallback: function() {
                $("* .editBtn").on("click", function(e) {
                    e.preventDefault();
                    try {
                        var d = $(this).data('all');
                        const modal = new bootstrap.Modal(document.getElementById('editModal'));

                        $("#editModal [name='c_id']").val(d.id);
                        $("#editModal [name='market']").val(d.market);
                        $("#editModal [name='base_symbol']").val(d.base_symbol);
                        $("#editModal [name='quote_symbol']").val(d.quote_symbol);
                        $("#editModal [name='current_price']").val(d.current);
                        $("#editModal .modal-title").text("Edit Asset: " + d.symbol);

                        modal.show();
                    } catch (err) {
                        alert(err);
                    }
                });

                $("* .deleteBtn").on("click", function(e) {
                    e.preventDefault();
                    try {
                        var d = $(this).data('all');
                        const modal = new bootstrap.Modal(document.getElementById('deleteAssetModal'));

                        $("#deleteAssetModal [name='c_id']").val(d.id);
                        $("#deleteAssetModal .modal-title").text("Delete Asset: " + d.symbol
                            .toUpperCase());

                        modal.show();
                    } catch (err) {
                        alert(err);
                    }
                });

            }
        });
    </script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<style>
    .asset-img {
        position: relative;
        width: 40px;
        height: 40px;
        padding-top: 10px;
    }

    .asset-img img:nth-child(1){
        position: absolute;
        width: 22px;
        height: 22px;
        border-radius: 50%;
        top: 10px;
        z-index: 10;
    }

    .asset-img img:nth-child(2){
        position: absolute;
        width: 22px;
        height: 22px;
        border-radius: 50%;
        top: 2px;
        left: 25px;
    }
</style>
    <!-- [ Main Content ] start -->
    <div class="row">

        <div class="col-md-12 mb-3">
            
            <button type="button" class="btn btn-dark btn-sm" data-bs-toggle="modal" data-bs-target="#addAssetModal">Add
                Asset</button>
        </div>

        <div class="col-md-12">
            <?php echo $__env->make('layouts/flash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>

        <div class="col-md-12">
            <div class="card table-card">
                <div class="card-header d-flex align-items-center justify-content-between py-3">
                    <h5>All Assets</h5>
                    <div class="dropdown">

                    </div>
                </div>
                <div class="card-body py-3 px-4">
                    <div class="table-responsive">
                        <table id="ast-dt" class="table table-hover table-bordered table-sm nowrap mb-4 mt-3">
                            <thead>
                                <tr class="border-bottom-secondary border-top-1">
                                    <th scope="col">S/N</th>
                                    <th scope="col"></th>
                                    <th scope="col">Symbol</th>
                                    <th scope="col">Market</th>
                                    <th scope="col">Current</th>
                                    <th scope="col">Image</th>

                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $assets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="" style="font-size: 13px;">
                                        <td><?php echo e($loop->iteration); ?></td>

                                        <td style="">

                                            <button class="btn btn-default btn-sm dropdown-toggle" type="button"
                                                data-bs-toggle="dropdown" aria-haspopup="true"
                                                aria-expanded="false">Actions</button>
                                            <div class="dropdown-menu" style="">
                                                <a class="dropdown-item editBtn" data-all="<?php echo e(json_encode($r)); ?>">Edit
                                                </a>

                                                <a class="dropdown-item deleteBtn"
                                                    data-all="<?php echo e(json_encode(['id' => $r->id, 'symbol' => $r->symbol])); ?>">
                                                    Delete</a>
                                            </div>

                                        </td>

                                        <td class="uppercase"><?php echo e($r->symbol); ?></td>
                                        <td><?php echo e($r->market); ?></td>
                                        <td><?php echo e($r->current); ?></td>
                                        <td class="asset-img">
                                            <?php if($r->base_image_url): ?>
                                                <img src="<?php echo e($r->base_image_url); ?>" alt="" class=""
                                                    width="30">
                                            <?php endif; ?>
                                            <?php if($r->quote_image_url): ?>
                                                <img src="<?php echo e($r->quote_image_url); ?>" alt="" class=""
                                                    width="30">
                                            <?php endif; ?>
                                        </td>

                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>
                </div>


            </div>
        </div>
    </div>

    <div id="addAssetModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add New Asset</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <form action="" method="POST" enctype="multipart/form-data">
                            <?php echo e(csrf_field()); ?>


                            <div class="row">
                                <div class="form-group col-md-6  mb-3">
                                    <label>Base Symbol *</label>
                                    <input type="text" class="form-control" name="base_symbol"
                                        value="<?php echo e(old('base_symbol')); ?>">
                                </div>

                                <div class="form-group col-md-6  mb-3">
                                    <label>Quote Symbol *</label>
                                    <input type="text" class="form-control" name="quote_symbol"
                                        value="<?php echo e(old('quote_symbol')); ?>">
                                </div>
                            </div>

                            <div class="row">

                                <div class="form-group col-md-6  mb-3">
                                    <label>Market *</label>
                                    <select class="form-control" name="market">
                                        <option></option>
                                        <?php $__currentLoopData = $markets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e(strtolower($r->name)); ?>"><?php echo e(strtolower($r->name)); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="form-group col-md-6  mb-3">
                                    <label>Current Price *</label>
                                    <input type="text" class="form-control" name="current_price"
                                        value="<?php echo e(old('current_price')); ?>">
                                </div>

                            </div>

                            <div class="row">
                                <div class="form-group col-md-6 mb-3">
                                    <label>Base Image</label>
                                    <input type="file" name="base_image" class="form-control">
                                </div>

                                <div class="form-group col-md-6 mb-3">
                                    <label>Quote Image</label>
                                    <input type="file" name="quote_image" class="form-control">
                                </div>
                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-dark" name="create_asset">Submit</button>
                            </div>

                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                </div>
            </div>
        </div>
    </div>

    <div id="editModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Asset</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <form action="" method="POST" enctype="multipart/form-data">
                            <?php echo e(csrf_field()); ?>


                            <div class="row">
                                <div class="form-group col-md-6  mb-3">
                                    <label>Base Symbol *</label>
                                    <input type="text" class="form-control" name="base_symbol" value="">
                                    <input type="hidden" name="c_id" value="">
                                </div>

                                <div class="form-group col-md-6  mb-3">
                                    <label>Quote Symbol *</label>
                                    <input type="text" class="form-control" name="quote_symbol" value="">
                                </div>
                            </div>

                            <div class="row">

                                <div class="form-group col-md-6  mb-3">
                                    <label>Market *</label>
                                    <select class="form-control" name="market">
                                        <option></option>
                                        <?php $__currentLoopData = $markets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e(strtolower($r->name)); ?>"><?php echo e(strtolower($r->name)); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="form-group col-md-6  mb-3">
                                    <label>Current Price *</label>
                                    <input type="text" class="form-control" name="current_price" value="">
                                </div>

                            </div>

                            <div class="row">
                                <div class="form-group col-md-6 mb-3">
                                    <label>Base Image</label>
                                    <input type="file" name="base_image" class="form-control">
                                </div>

                                <div class="form-group col-md-6 mb-3">
                                    <label>Quote Image</label>
                                    <input type="file" name="quote_image" class="form-control">
                                </div>
                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-dark" name="edit_asset">Update</button>
                            </div>

                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                </div>
            </div>
        </div>
    </div>

    <div id="deleteAssetModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Asset</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <form action="" method="POST">
                            <?php echo e(csrf_field()); ?>


                            <div class="form-group mb-3">
                                <p class="">Are you sure?</p>
                                <input type="hidden" name="c_id" class="form-control">
                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-danger" name="delete_asset">Delete</button>
                            </div>

                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nlgasisc/phoenixfundlimited.com/port/resources/views/admin/assets.blade.php ENDPATH**/ ?>