<div>
    <script type="text/javascript">
        $(document).ready(function() {
            $('#ast-dt-trade').DataTable({
                drawCallback: function() {
                    $("* .editTradeBtn").on("click", function(e) {

                        e.preventDefault();
                        try {
                            var d = $(this).data('all');
                            const modal = new bootstrap.Modal(document.getElementById(
                                'editTradeModal'));

                            $("#editTradeModal [name='trade_id']").val(d.id);
                            $("#editTradeModal [name='entry_price']").val(d.entry_price);
                            $("#editTradeModal [name='trade_action']").val(d.trade_action);
                            $("#editTradeModal .modal-title").text("Edit Trade: " + d.uuid);

                            modal.show();
                        } catch (err) {
                            alert(err);
                        }
                    });

                    $("* .copyTradeBtn").on("click", function(e) {
                        e.preventDefault();
                        try {
                            var d = $(this).data('all');
                            const modal = new bootstrap.Modal(document.getElementById(
                                'copyTradeModal'));

                            $("#copyTradeModal [name='trade_id']").val(d.id);
                            $("#copyTradeModal [name='trader_id']").val(d.trader_id);
                            $("#copyTradeModal [name='entry_price']").val(d.entry_price);
                            $("#copyTradeModal [name='close_price']").val(d.close_price);
                            $("#copyTradeModal [name='opened_at']").val(d.opened_at);
                            $("#copyTradeModal .modal-title").text("Copy Trade: " + d.uuid);

                            modal.show();
                        } catch (err) {
                            alert(err);
                        }
                    });

                    $("* .deleteTradeBtn").on("click", function(e) {
                        e.preventDefault();
                        try {
                            var d = $(this).data('all');
                            const modal = new bootstrap.Modal(document.getElementById(
                                'deleteTradeModal'));

                            $("#deleteTradeModal [name='c_id']").val(d.id);
                            $("#deleteTradeModal .modal-title").text("Delete Trade: " + d.uuid
                                .toUpperCase());

                            modal.show();
                        } catch (err) {
                            alert(err);
                        }
                    });

                    handleOverflowForAllTablesCustom("flowTable-trades");
                    bindToggleEventsCustom("tgdx-trades");

                }
            });
        });
    </script>
    
    <table id="ast-dt-trade" class="flowTable-trades table table-hover table-bordered table-sm nowrap mb-4 mt-3">
        <thead>
            <tr class="border-bottom-secondary border-top-1" style="font-size: 11px!important;">
                <th scope="col">S/N</th>
                <th scope="col">k</th>
                <th scope="col">d</th>
                <th scope="col">ID</th>
                <th scope="col">Source</th>
                <?php if(!$user): ?>
                    <th scope="col">User</th>
                <?php endif; ?>
                <th scope="col">Symbol</th>
                <th scope="col">Market</th>
                <th scope="col">Type</th>
                <th scope="col">Amount</th>
                <th scope="col">Entry Price</th>
                <th scope="col">Order</th>
                <th scope="col">Close Price</th>
                <th scope="col">Payout</th>
                <th scope="col">Result</th>
                <th scope="col">P/L</th>
                <th scope="col">Closed</th>
                <th scope="col">Date</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $trades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="" style="font-size: 12px;">
                    <td>
                        <?php echo e($loop->iteration); ?>

                    </td>
                    <td>
                        <button class="btn btn-dark btn-sm tgdx-trades"
                            style="padding-top: 0px; padding-bottom: 0px;">+</button>
                    </td>

                    <td style="">

                        <button class="btn btn-default btn-sm dropdown-toggle" type="button" data-bs-toggle="dropdown"
                            aria-haspopup="true" aria-expanded="false">Actions</button>
                        <div class="dropdown-menu" style="">
                            <a class="dropdown-item editTradeBtn" data-all="<?php echo e(json_encode($r)); ?>">Edit Trade
                            </a>

                            <a class="dropdown-item copyTradeBtn" data-all="<?php echo e(json_encode($r)); ?>">Copy Trade
                            </a>

                            <a class="dropdown-item deleteTradeBtn"
                                data-all="<?php echo e(json_encode(['id' => $r->id, 'uuid' => $r->uuid])); ?>">
                                Delete</a>
                        </div>

                    </td>

                    <td class=""><?php echo e($r->uuid); ?></td>
                    <td class="capitalize"><?php echo e(!$r->source ? 'Manual Trade' : $r->source); ?></td>
                    <?php if(!$user): ?>
                        <td class="capitalize">
                            <a target="_blank" href="<?php echo e(route('admin.user.trader', $r->trader_id)); ?>" class="">
                                <?php echo e($r->user?->fullname); ?>

                            </a>
                            
                        </td>
                    <?php endif; ?>
                    <td class="uppercase"><?php echo e($r->symbol); ?></td>
                    <td><?php echo e($r->market); ?></td>
                    <td><?php echo e($r->trade_type); ?></td>
                    <td class="digits text-uppercase"><?php echo e($r->amount); ?> <?php echo e($r->currency); ?></td>
                    <td><?php echo e($r->entry_price); ?></td>
                    <td><?php echo e($r->fmt_trade_action); ?></td>
                    <td><?php echo e($r->close_price); ?></td>
                    <td class="digits text-uppercase"><?php echo e($r->payout); ?> <?php echo e($r->currency); ?></td>
                    <td><?php echo e($r->result); ?></td>
                    <td class="digits text-uppercase"><?php echo e($r->profit_loss); ?> <?php echo e($r->currency); ?></td>
                    <td class=""><?php echo e($r->is_trade_done == 1 ? 'YES' : 'NO'); ?></td>
                    <td><?php echo e($r->created_at); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </tbody>
    </table>

    <div id="editTradeModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Trade</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <form action="<?php echo e(route('admin.component.trades')); ?>" method="POST">
                            <?php echo e(csrf_field()); ?>


                            <div class="form-group mb-3">
                                <label for="">Entry Price</label>
                                <input type="text" name="entry_price" class="form-control">
                                <input type="hidden" name="trade_id">
                            </div>

                            <div class="form-group mb-3">
                                <label for="">Order</label>
                                <select name="trade_action" class="form-control">
                                    <option value="up"><?php echo e(\App\Helpers\FilterHelper::formatTradeAction('up')); ?>

                                    </option>
                                    <option value="down"><?php echo e(\App\Helpers\FilterHelper::formatTradeAction('down')); ?>

                                    </option>
                                </select>
                            </div>


                            <div class="form-group">
                                <button type="submit" class="btn btn-danger" name="edit_trade">Update</button>
                            </div>

                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                </div>
            </div>
        </div>
    </div>


    <div id="deleteTradeModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Trade</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <form action="" method="POST">
                            <?php echo e(csrf_field()); ?>


                            <div class="form-group mb-3">
                                <p class="">Are you sure?</p>
                                <input type="hidden" name="c_id" class="form-control">
                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-danger" name="delete_trade">Delete</button>
                            </div>

                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                </div>
            </div>
        </div>
    </div>

    <div id="copyTradeModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Copy Trade</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <form action="<?php echo e(route('admin.component.trades')); ?>" method="POST">
                            <?php echo e(csrf_field()); ?>


                            <div class="form-group mb-3">
                                <label for="">Entry Price</label>
                                <input type="text" name="entry_price" class="form-control">

                            </div>

                            <div class="form-group mb-3">
                                <label for="">Close Price</label>
                                <input type="text" name="close_price" class="form-control">
                            </div>

                            <div class="form-group">
                                <label for="">Select User</label>
                                <br/>
                                
                                <select name="trader_id" class="form-control">
                                    <?php $__currentLoopData = $trading_accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($t->id); ?>"><?php echo e($t->type); ?> Account (<?php echo e($t->uuid); ?>) / <?php echo e($t->user?->fullname); ?> - <?php echo e($t->balance); ?> <?php echo e($t->currency); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="form-group">
                                <label for="">Select Top Trader</label>
                                <br/>
                                <select name="toptrader_id" class="form-control">
                                    <option value=""></option>
                                    <?php $__currentLoopData = $toptraders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($t->username); ?>"><?php echo e($t->fullname); ?> - <?php echo e($t->username); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="form-group mb-3">
                                <label for="">Trade Date</label>
                                <input type="text" name="opened_at" class="form-control">
                                <p class="">Must be in format YYYY-MM-DD HH:MM:SS e.g 2025-01-22 03:21:21</p>
                            </div>


                            <div class="form-group">
                                <input type="hidden" name="trade_id">
                                <button type="submit" class="btn btn-danger" name="copy_trade">Update</button>
                            </div>

                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/nlgasisc/phoenixfundlimited.com/port/resources/views/components/trades.blade.php ENDPATH**/ ?>